//
//  table_C_P_A_L_.h
//  GSFontTools
//
//  Created by Georg Seifert on 31.07.13.
//
//
#import "TTable.h"

@interface OTColrColorRecord : NSObject <NSCopying> {
	NSColor * _color;
@public;
	uint8_t   _blue;    //Blue value (B0).
	uint8_t   _green;   //Green value (B1).
	uint8_t   _red;     //Red value (B2).
	uint8_t   _alpha;   //Alpha value (B3).
}
@property (nonatomic, retain) NSColor* color;
- (BOOL) decompile:(NSData*)Data pos:(NSUInteger*)pos font:(TTFont*)Font error:(NSError**)error ;
- (BOOL) compile:(NSMutableData*)Data font:(TTFont*)Font error:(NSError**)error ;
- (void) toXML:(GSXMLWriter*)Writer index:(NSUInteger)Index;
@end

@interface table_C_P_A_L_ : TTable {
	uint16_t       _version;                           // Table version number (0).
	//uint16_t       _numPaletteEntries;                 // Number of palette entries in each palette.
	//uint16_t       _numPalettes;                       // Number of palettes in the table.
	//uint16_t       _numColorRecords;                   // Total number of color records, combined for all palettes.
	//uint32_t       _offsetFirstColorRecord;            // Offset from the beginning of CPAL table to the first ColorRecord.
	//NSMutableIndexSet * _colorRecordIndices;		   //[numPalettes]   //Index of each palette's first color record in the combined color record array.
	//NSMutableArray *  _colorRecords;                    //Color records for all palettes.
	NSMutableArray * _colorPalettes;
}
@property (nonatomic) uint16_t version;
@property (nonatomic, retain) NSMutableArray* colorPalettes;

@end
