//
//  table_O_S_2f_2.h
//  GSFontTools
//
//  Created by Georg Seifert on 09.11.12
//  Copyright 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "OTTables.h"

// panose classification
//
typedef struct {
	uint8_t panoseFamilyType; //        B
	uint8_t panoseSerifStyle; //      B
	uint8_t panoseWeight; //          B
	uint8_t panoseProportion; //      B
	uint8_t panoseContrast; //        B
	uint8_t panoseStrokeVariation; // B
	uint8_t panoseArmStyle; //        B
	uint8_t panoseLetterForm; //      B
	uint8_t panoseMidline; //         B
	uint8_t panoseXHeight; //         B
} panoseFormat;

typedef struct {
	uint16_t version; //                H       // version
	int16_t xAvgCharWidth; //          h       // average character width
	uint16_t usWeightClass; //          H       // degree of thickness of strokes
	uint16_t usWidthClass; //           H       // aspect ratio
	int16_t fsType; //                 h       // type flags
	int16_t ySubscriptXSize; //        h       // subscript horizontal font size
	int16_t ySubscriptYSize; //        h       // subscript vertical font size
	int16_t ySubscriptXOffset; //      h       // subscript x offset
	int16_t ySubscriptYOffset; //      h       // subscript y offset
	int16_t ySuperscriptXSize; //      h       // superscript horizontal font size
	int16_t ySuperscriptYSize; //      h       // superscript vertical font size
	int16_t ySuperscriptXOffset; //    h       // superscript x offset
	int16_t ySuperscriptYOffset; //    h       // superscript y offset
	int16_t yStrikeoutSize; //         h       // strikeout size
	int16_t yStrikeoutPosition; //     h       // strikeout position
	int16_t sFamilyClass; //           h       // font family class and subclass
	uint8_t panose[10];
	uint16_t ulUnicodeRange1a; //        L       // character range
	uint16_t ulUnicodeRange1b; //        L       // character range
	uint16_t ulUnicodeRange2a; //        L       // character range
	uint16_t ulUnicodeRange2b; //        L       // character range
	uint16_t ulUnicodeRange3a; //        L       // character range
	uint16_t ulUnicodeRange3b; //        L       // character range
	uint16_t ulUnicodeRange4b; //        L       // character range
	uint16_t ulUnicodeRange4a; //        L       // character range
	char achVendID[4]; //              4s      // font vendor identification
	uint16_t fsSelection; //            H       // font selection flags
	uint16_t fsFirstCharIndex; //       H       // first unicode character index
	uint16_t fsLastCharIndex; //        H       // last unicode character index
	int16_t sTypoAscender; //          h       // typographic ascender
	int16_t sTypoDescender; //         h       // typographic descender
	int16_t sTypoLineGap; //           h       // typographic line gap
	uint16_t usWinAscent; //            H       // Windows ascender
	uint16_t usWinDescent; //           H       // Windows descender
	
	uint16_t ulCodePageRange1a; //  L
	uint16_t ulCodePageRange1b; //  L
	uint16_t ulCodePageRange2a; //  L
	uint16_t ulCodePageRange2b; //  L
	int16_t sxHeight; //          h
	int16_t sCapHeight; //        h
	int16_t usDefaultChar; //     H
	int16_t usBreakChar; //       H
	int16_t usMaxContex; //       H
} OS2_format_2;

@interface table_O_S_2f_2 : BaseTTXConverter {
	NSUInteger _version;
	OS2_format_2 _format;
}
@property (nonatomic, assign) NSUInteger version;
@property (nonatomic, assign) OS2_format_2 format;
@end