//
//  GSAlignmentZone.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFontMaster;

@interface GSAlignmentZone : NSObject {
	GSFontMaster* __unsafe_unretained parent;
	NSString* _name;
	NSInteger position;
	NSInteger size;
	NSMutableArray* _scripts;
}
@property (nonatomic, strong) NSString* name;
@property (nonatomic) NSInteger position;
@property (nonatomic) NSInteger size;
@property (unsafe_unretained, nonatomic) GSFontMaster* parent;
@property (nonatomic, strong) NSMutableArray* scripts;

- (instancetype)initWithElementString:(NSString*)String;

- (NSString*)elementString;

#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File error:(NSError**)error;

- (void)addScript:(id)aScript;

- (void)removeScript:(id)aScript;

- (NSUInteger)countOfScripts;

//- (void)getScripts:(id*)buffer range:(NSRange)inRange;
- (id)objectInScriptsAtIndex:(NSUInteger)idx;

- (void)insertObject:(NSMutableDictionary*)aNSMutableDictionary inScriptsAtIndex:(NSUInteger)idx;

- (void)insertScripts:(NSArray*)_scriptArray atIndexes:(NSIndexSet*)indexes;

- (void)removeObjectFromScriptsAtIndex:(NSUInteger)idx;

- (void)removeScriptsAtIndexes:(NSIndexSet*)indexes;

- (void)replaceObjectInScriptsAtIndex:(NSUInteger)idx withObject:(NSMutableDictionary*)aNSMutableDictionary;

- (void)replaceScriptsAtIndexes:(NSIndexSet*)indexes withScripts:(NSArray*)_scriptArray;

#endif
@end
