//
//  GSAnchor.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.8.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"

typedef NS_ENUM(uint8_t, GSAnchorType) {
	BaseAnchor = 0,
	MarkAnchor = 1
};

/// The class defining the anchor object

@interface GSAnchor : GSElement <NSCoding, NSCopying> {

	NSString* _name;
	GSAnchorType _type;
	BOOL _selected;
}

/// Name of the anchor.
@property (copy, nonatomic) NSString* name;

@property (nonatomic) GSAnchorType type;

@end
