//
//  GSClass.h
//  GlyphsCore
//
//  Created by Georg Seifert on 25.10.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;

@interface GSClass : NSObject <NSCoding, NSCopying> {
	GSFont* __unsafe_unretained _parent;
	NSString* _name;
	NSString* _code;
	BOOL _automatic;
	BOOL _disabled;
	NSString* _notes;
}
@property (nonatomic, unsafe_unretained) GSFont* parent;
@property (nonatomic, copy) NSString* name;
//! The feature representation on FDK syntax.
@property (strong, nonatomic) NSString* code;

//! if the class is replaced on automatic feature generation.
@property (nonatomic) BOOL automatic;

/// If True, the feature will not be exported.
@property (nonatomic) BOOL disabled;

@property (nonatomic, strong) NSString* notes;
@property (nonatomic, unsafe_unretained) NSDictionary* classDict;
#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File error:(NSError**)error;

- (void)update;
#endif
@end
