//
//  GSElement.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/** GSElement: The base class for Layer elements.

 The base class for Layer elements.
 */

@interface GSElement : NSObject <NSCoding, NSCopying> {
@public
	id __unsafe_unretained _parent;
	NSPoint _position;
	NSPoint _positionPrecise;
}
/// The position of the element.
@property (assign, nonatomic) NSPoint position;

/** The unrounded position of the element.
 
 This is used for consecutiv operations to avoid rounding errors
 */
@property (nonatomic, readonly) NSPoint positionPrecise;

/// Returns/sets the content of the element to store in pList. 
@property (unsafe_unretained, nonatomic) NSDictionary* elementDict;

/// A Pointer to the containing object
@property (unsafe_unretained, nonatomic) id parent;

/** initialises a element with a dictionary loaded from a pList.

@param ElementDict A dictionary
*/
- (instancetype)initWithElementDict:(NSDictionary*)ElementDict;

#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File compact:(BOOL)Compact error:(NSError**)error;
- (BOOL)saveToFile:(FILE*)File error:(NSError**)error;

#endif

- (NSRect)getHandleRect:(NSPoint)pt scale:(CGFloat)Scale;

- (NSRect)bounds;
//- (void) drawInView:(id) View ;
//- (BOOL) hitTest:(NSPoint) Point ;
@end
