//
//  GSFeature.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSSubstitution;
@class GSFont;

/** The class defining the feature object
 
 This class defines the feature object. It is used to store OpenType features in Adobe FDK syntax
 */
@interface GSFeature : NSObject <NSCoding, NSCopying> {
	GSFont* __unsafe_unretained _parent;
	NSInteger _index;
	NSString* _name;
	NSString* _code;
	NSMutableArray* _substitutions;
	BOOL _automatic;
	BOOL _disabled;
	NSString* _notes;
	NSString* _flag;
	
}
@property (unsafe_unretained, nonatomic) GSFont* parent;

/** The feature name.
 
 e.g: "liga", "smcp", ..
*/
@property (copy, nonatomic) NSString* name;

//! The feature representation in FDK syntax.
@property (strong, nonatomic) NSString* code;

//! Returns a dictionary to save in pList.
@property (unsafe_unretained, nonatomic) NSDictionary* featureDict;

@property (strong, nonatomic) NSArray* substitutions;
@property (strong, nonatomic) NSString* flag;

/** Feature will be automaticaly generated.
 
 Defaults to YES, set it to NO if you want to edit the feature manually.
*/
@property (nonatomic) BOOL automatic;

/// If True, the feature will not be exported.
@property (nonatomic) BOOL disabled;

/** Some extra text.
 
 Is shown in the bottom of the feature window.
 
 Contains the stylistic set name parameter
 */
@property (copy, nonatomic) NSString* notes;
#ifndef GLYPHS_VIEWER

- (BOOL)saveToFile:(FILE*)File error:(NSError**)error;

- (GSSubstitution*)substitutionForSourceGlyph:(NSString*)Source;

- (void)addSubstitution:(GSSubstitution*)subst;

- (void)removeSubstitution:(GSSubstitution*)subst;

- (void)addSubstitutions:(NSArray*)substs;

/**
 Invoce this method to regenerate the feature
 
 If the feature is not set to be automatic, this does nothing
 */
- (void)update;
#endif
@end
