//
//  GSGlyphViewProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSGeometrieHelper.h"

typedef NS_ENUM(uint8_t, GSKerningMode) {
	GSKerningNormal = 1,
	GSKerningContextual = 2
} ;

@class GSLayer;
@class YLTextStorage;
@class YLLayoutManager;

/** This protocol defines the API for the graphicView */
@protocol GSGlyphEditViewProtocol

/** The active layer
 
 If only one layer is selected it retunes it, otherwise it retunes nil.
 
 In the editview, this is the layer that has a gray info box.
 */
@property (nonatomic, assign) GSLayer* activeLayer;

/** The position of the activeLayer
 
 This is in scaled view coordinates.
 
 @see scale
 */
@property (nonatomic) NSPoint activePosition;

/// The scale of the view
@property (nonatomic) CGFloat scale;

/// The index of the character of the active layer in the string
@property (nonatomic) NSUInteger activeIndex;

/** number of layers in the view.
 
 This might be difference than the number of characters in the string after the features are applied
 */
@property (nonatomic, readonly) NSUInteger cachedCount;

/// the selection range as in the original string
@property (nonatomic) NSRange selectedRange;

/// the selection range after features are applied
@property (nonatomic, readonly) NSRange cachedSelectionRange;

/// the currently active cursor
@property (nonatomic, retain) NSCursor* cursor;

@property (nonatomic) NSRect glyphFrame;

/** the text storage */
@property (strong, nonatomic) YLTextStorage* textStorage;

@property (nonatomic) GSKerningMode kerningMode;

/// Set if kerning is active
@property (nonatomic, assign) BOOL doKerning;

/// Set if spacing is active
@property (nonatomic, assign) BOOL doSpacing;

/// The zoom transformer that translates glyphs coordinates
@property (strong, nonatomic) NSAffineTransform* zoomTransformer;

/// The layout manager
@property (strong, nonatomic) YLLayoutManager* layoutManager;

///

/** Translates the view coordinate from the event into glyph coordinates of the active layer
 
 @param theEvent a mouse down even
 
 @return The coordinates
 */
- (NSPoint)getActiveLocation:(NSEvent*)theEvent;

/** Returns the cached layer at index
 
 @param Index The cached index
 
 @return The layer
 */
- (GSLayer*)cachedGlyphAtIndex:(NSUInteger)Index;

/** Returns the cached position at index
 
 @param Index The cached index
 
 @return the position
 */
- (NSPoint)cachedPositionAtIndex:(NSUInteger)Index;

/** The character at the position in view coordinates
 
 @param thePoint the position to check
 
 @return the character thats bounding box is contains the point
 */
- (NSUInteger)characterIndexForPoint:(NSPoint)thePoint;

- (void)drawLayer:(GSLayer*)Layer atPoint:(NSPoint)aPoint asActive:(BOOL)Active attributes:(NSDictionary*)Attributes;

- (void)drawLayerOutlines:(GSLayer*)Layer aPoint:(NSPoint)Position color:(NSColor*)Color fill:(BOOL)Fill;

- (NSDictionary *)drawTextAttributes:(NSColor*)TextColor;

- (NSRect)drawText:(NSString*)Text atPoint:(NSPoint)DrawPoint withColor:(NSColor*)TextColor alignment:(GSAlignment)Alignment;

- (NSRect)drawText:(NSString*)Text atPoint:(NSPoint)Position withColor:(NSColor*)TextColor;

- (NSRect)drawText:(NSAttributedString*)AttributedString atPoint:(NSPoint)aPoint alignment:(GSAlignment)Aligment;

- (NSRect)drawBadge:(NSString*)Text atPoint:(NSPoint)DrawPoint alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect;

- (NSRect)drawBadge:(NSString *)Text atPoint:(NSPoint)DrawPoint alignment:(GSAlignment)Alignment visibleInRect:(NSRect)VisibleRect active:(BOOL)Active;
//- (void) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (GSAlignment) Alignment ;
- (void)drawBadge:(NSString*)Text atPoint:(NSPoint)DrawPoint alignment:(GSAlignment)Alignment;

- (void)reflow;
@end
