//
//  GSGlyphsInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSGlyphInfo;
@class GSGlyph;
@class GSFont;
@class GSLayer;
@class MGOrderedDictionary;

/*! \brief GSGlyphsInfos: This is a singlton class to provide glyphinfo services.
 \ingroup common
 This is a singlton class to provide glyphinfo services.
 */
@interface GSGlyphsInfo : NSObject <NSXMLParserDelegate> {
	NSMutableArray* _glyphInfos;
	NSArray* _glyphGroupsTree;
	NSMutableArray* _categories;
	NSDictionary* _categoryIndexes;
	NSDictionary* _subcategories;
	NSMutableDictionary* _name2Group;
	NSMutableDictionary* _name2Info;
	NSMutableDictionary* _unicode2Info;
	NSMutableDictionary* _languages;
	NSMutableArray* _scripts;
	NSDictionary* _scriptIndexes;
	NSDictionary* _anchors;
	NSDictionary* _customPropertyTypes;
	NSArray* _customFontProperties;
	NSArray* _customMasterProperties;
	NSArray* _customInstanceProperties;
	NSDictionary* _basicFontInfoProperties;
	IBOutlet NSArrayController* _glyphGroupsTreeTreeController;
	bool updating;

	NSDictionary* _widthClasses;
	NSDictionary* _weightClasses;
	NSDictionary* _scriptAbrevations;
	NSDictionary* _scriptSuffixes;
	NSDictionary* _languageScripts;
	NSArray* _languageData;
	NSArray* _unicodeRanges;
	NSMutableDictionary* _scriptRanges;
	NSSet* _indicScripts;
@private
	NSMutableDictionary* _subGroupCache;
	NSDateFormatter* _dateFormat;

}
/** An array of glyph groups.

This is used the build the filter tree in font view mode.
*/
@property (readonly, nonatomic) NSArray* glyphGroupsTree;
@property (readonly, nonatomic) NSMutableArray* categories;
@property (readonly, nonatomic) NSMutableDictionary* name2Group;
/// The array containing the glyphs info data.
@property (strong, nonatomic) NSMutableArray* glyphInfos;
@property (readonly, nonatomic) NSMutableArray* scripts;
@property (readonly, nonatomic) NSDictionary* customPropertyTypes;
@property (readonly, nonatomic) NSArray* customFontProperties;
@property (readonly, nonatomic) NSArray* customMasterProperties;
@property (readonly, nonatomic) NSArray* customInstanceProperties;

@property (readonly, nonatomic) NSDictionary* basicFontInfoProperties;
@property (readonly, nonatomic) NSMutableDictionary* languages;
/// The widthclasses
@property (readonly, nonatomic) NSDictionary* widthClasses;
/// The weightclasses
@property (readonly, nonatomic) NSDictionary* weightClasses;
@property (readonly, nonatomic) NSDictionary* name2Info;
@property (readonly, nonatomic) NSDictionary* scriptRanges;
@property (readonly, nonatomic) NSSet* indicScripts;

/// Returns the shared GlyphsInfos object.
+ (GSGlyphsInfo*)sharedManager;

- (void)loadGlyphInfo;

+ (NSDateFormatter*)dateFormat;

+ (NSString*)applicationSupportFolder;

- (void)reloadCustomFilterGroup;

- (NSDictionary*)loadCustomFilterGroup;

/** Returns the GSGlyphInfo for the glyph with Glyph.

@param Glyph The glyph.
@return A GSGlyphInfo instance or nil.
*/
+ (GSGlyphInfo*)glyphInfoForGlyph:(GSGlyph*)Glyph;

/** Returns the GSGlyphInfo for the glyph with Name.

@param Name The glyph name.
@return A GSGlyphInfo instance or nil.
*/
+ (GSGlyphInfo*)glyphInfoForName:(NSString*)Name;
- (GSGlyphInfo*)glyphInfoForName:(NSString*)Name;

/** Returns the GSGlyphInfo for the glyph with Unicode.

@param Unicode A unicode as Hex string.
@return A GSGlyphInfo instance or nil.
*/
+ (GSGlyphInfo*)glyphInfoForUnicode:(NSString*)Unicode;

- (GSGlyphInfo*)glyphInfoForName:(NSString*)Name componentNames:(NSArray*)ComponentNames LangTag:(NSString*)LangTag;

- (GSGlyphInfo*)glyphInfoForName:(NSString*)Name componentNames:(NSArray*)ComponentNames LangTag:(NSString*)LangTag thin:(BOOL)Thin;

/// Returns the index of the glyph in the database.
- (NSUInteger)glyphIndex:(GSGlyph*)Glyph;

/**
 Updates the glyph info in the Glyph.
 
 @param glyph      The Glyph
 @param changeName Keep the name and only update unicode, categories and script
 */
+ (void)updateGlyphInfo:(GSGlyph*)glyph changeName:(BOOL)changeName;

#ifndef GLYPHS_VIEWER

///

/** Generates missing anchors in the Layer.
 
 @param Layer The Layer
 
 @return YES if it changed anything.
 */
+ (BOOL)updateAnchor:(GSLayer*)Layer;

#endif

/** Converts a name to a standardised name

 e.g. converts afii10017 to A-cy
 
 @param name The name.
 @return The nice-name.
 
 @see productionGlyphNameForName:
*/
+ (NSString*)niceGlyphNameForName:(NSString*)name;

/** Converts a name to a production name
 
 @param name The name.
 @return The produciton name.
 @see niceGlyphNameForName:
 */
+ (NSString*)productionGlyphNameForName:(NSString*)name;

/** Converts all glyph names to production names 
 
 This is usefull for OT-feature code
 
 @param string A string that contains glyph names like feature code.
 @return The string with converted names.
 */
+ (NSString*)convertToLegecyNames:(NSString*)string;

+ (void)fixASCIINames:(GSFont*)Font;

+ (NSString*)decomposeHangul:(unichar)s;

+ (BOOL)decomposeHangul:(unichar)s leadingConsonant:(unichar*)LeadingConsonant vowel:(unichar*)Vowel trailingConsonant:(unichar*)TrailingConsonant;

+ (NSArray*)compleationsForName:(NSString*)PartialName forPartialWordRange:(NSRange)charRange;

+ (NSUInteger)indexOfObjectInScripts:(NSString*)Script;

- (NSUInteger)_indexOfObjectInScripts:(NSString*)Script;

- (NSUInteger)_indexOfObjectInCategories:(NSString*)Category;

- (NSMutableDictionary*)_subcategoriesForCategory:(NSString*)Category;

+ (NSDictionary*)scriptAbrevations;

+ (NSDictionary*)scriptSuffixes;

+ (NSDictionary*)languageScripts;

+ (NSArray*)languageData;

#ifndef GLYPHS_VIEWER

+ (NSMutableString*)windowsLinkedToStyle:(GSFont*)Font;

+ (NSMutableString*)macStyle:(GSFont*)Font;

#endif

- (NSDictionary*)_scriptAbrevations;

- (NSDictionary*)_scriptSuffixes;

+ (NSArray*)unicodeRanges;

+ (NSString*)ligaNameForComponents:(NSArray*)Componetents;

+ (NSArray*)_componentsForLigaName:(NSString*)LigaName;

+ (NSString*)_langTagForName:(NSString*)Name;

+ (NSArray*)blueValues:(NSArray*)AlignmentZones;

+ (NSArray*)otherBlues:(NSArray*)AlignmentZones;

@end
