//
//  GSHint.h
//  GlyphsCore
//
//  Created by Georg Seifert on 21.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"

@class GSNode;
/**
 Hint types
 */

typedef NS_ENUM(int8_t, GSHintType){
	/**
	 Tag
	 */
	Tag = -2,
	/**
	 TopGhost for PS hints
	 */
	TopGhost = -1,
	/**
	 Stem for PS hints
	 */
	Stem = 0,
	/**
	 BottomGhost for PS hints
	 */
	BottomGhost = 1,
	/**
	 Anchor for TT hints
	 */
	TTAnchor = 2,
	/**
	 Stem for TT hints
	 */
	TTStem = 3,
	/**
	 Aling for TT hints
	 */
	TTAlign = 4,
	/**
	 Interpolation for TT hints
	 */
	TTInterpolate = 5,
	/**
	 Diagonal for TT hints
	 */
	TTDiagonal = 6,
	/**
	 Corner Component
	 */
	Corner = 16,
	/**
	 Cap Component
	 */
	Cap = 17,
	/**
	 Auto
	 */
	Auto = 0x7f,
} ;

/**
 Hint Options
 */
typedef NS_ENUM(uint8_t, GSHintOptions) {
	TTDontRound = 4,
	TTRound = 0,
	TTRoundUp = 1,
	TTRoundDown = 2,
	Trippel = 128,
} ;

@interface GSHint : GSElement <NSCoding, NSCopying> {

	GSNode* _originNode;
	GSNode* _targetNode;
	GSNode* _otherNode1;
	GSNode* _otherNode2;
	NSIndexPath* _originIndex;
	NSIndexPath* _targetIndex;
	NSIndexPath* _otherIndex1;
	NSIndexPath* _otherIndex2;

	GSHintType _type;
	NSRect _badgeRect;
	NSPoint _originKnob;
	NSPoint _targetKnob;
	NSPoint _otherKnob1;
	NSPoint _otherKnob2;
	int _selection;
	NSInteger _stem;
	NSString* _name;
	int _options;
	NSPoint _scale;
	NSDate *_lastUpdate;
@public
	NSUInteger _ttOriginIndex;
	NSUInteger _ttTargetIndex;
	NSUInteger _ttOtherIndex1;
	NSUInteger _ttOtherIndex2;
	CGFloat _origin;
	CGFloat _width;
	BOOL _horizontal;
}

@property (nonatomic) CGFloat origin;
@property (nonatomic) CGFloat width;
@property (nonatomic) BOOL horizontal;
@property (strong, nonatomic) GSNode* originNode;
@property (strong, nonatomic) GSNode* targetNode;
@property (strong, nonatomic) GSNode* otherNode1;
@property (strong, nonatomic) GSNode* otherNode2;
@property (strong, nonatomic) NSIndexPath* originIndex;
@property (strong, nonatomic) NSIndexPath* targetIndex;
@property (strong, nonatomic) NSIndexPath* otherIndex1;
@property (strong, nonatomic) NSIndexPath* otherIndex2;
@property (nonatomic) GSHintType type;
@property (nonatomic) NSRect badgeRect;
@property (nonatomic) NSPoint originKnob;
@property (nonatomic) NSPoint targetKnob;
@property (nonatomic) NSPoint otherKnob1;
@property (nonatomic) NSPoint otherKnob2;

@property (nonatomic) int selection;
@property (nonatomic) NSInteger stem;
@property (nonatomic, strong) NSString* name;
@property (nonatomic) int options;
@property (nonatomic) NSPoint scale;
@property (nonatomic, strong) NSDate* lastUpdate;

- (instancetype)initWithHintDict:(NSDictionary*)HintDict;

- (void)makeGhost;

- (void)save;

- (void)restore;

- (void)updateIndexes;

- (NSSet*)dependenIndexes;

- (NSSet*)touchingIndexes;

- (NSSet*)touchingIndexesAlreadyTouched:(NSSet*)AlreadyTouchedIndexes;

- (BOOL) isTrueType;

- (BOOL) isPostScript;

@end
