/*! \file GSNode.h */
//
//  GSNode.h
//  GlyphsCore
//
//  Created by Georg Seifert on 05.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"

/**
An enumeration of node and connection types.
*/
typedef NS_ENUM(uint8_t, GSNodeType) {
	/** Move */
	MOVE = 17,
	/// Line
	LINE = 1,
	/// Curve
	CURVE = 35,
	/// Offcurve
	OFFCURVE = 65,
	/// Sharp connection
	SHARP = 0,
	/// Smooth connection
	SMOOTH = 100,
	SPECIAL = 101
} ;

/** The class defining the node object

 It is a subclass of GSElement
 */
@interface GSNode : GSElement <NSCoding, NSCopying> {
@public
	GSNodeType _type;
	GSNodeType _connection;
	NSString* _name;
	//CGFloat _time;
	//CGFloat _angle;
	//NSPoint _delta;
}
/// node type
@property (assign, nonatomic) GSNodeType type;
/// connection type
@property (assign, nonatomic) GSNodeType connection;

@property (nonatomic, strong) NSString* name;

- (void)setElementString:(NSString*)String;

- (CFStringRef)copyElementString;

- (instancetype)initWithElementString:(NSString*)ElementString;

/** toggles the connection type between SHARP and SMOOTH */
- (void)toggleConnection;

/** Convenient method to make this the first node in the path.*/
- (void)makeNodeFirst;

/** Sets the position without notifying the path and no undo.
 
 This is mostly used to build a new path that is later added to the layer. Otherwise you need to make sure to anounce the changes. e.g. by calling `[layer elementDidChange:path];`.
 
 @param position The new position
 */
- (void)setPositionFast:(NSPoint)position;
@end
