//
//  GSNotifyingDictionary.h
//  GlyphsCore
//
//  Created by Georg Seifert on 29.09.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSElement;
#import "GSContainerProtocol.h"

@interface GSNotifyingDictionary : NSObject {
	NSMutableDictionary* _dict;
}
@property (weak, nonatomic) GSElement <GSContainerProtocol> * parent;

- (instancetype)initWithDictionary:(NSDictionary*)Dict ;
- (void)setObject:(id)Value forKey:(id)Key ;
- (void)setObject:(id)Value forKeyedSubscript:(id)Key ;
- (void)removeObjectForKey:(id)Key ;
- (id)objectForKey:(id)Key ;
- (id)objectForKeyedSubscript:(id)Key ;
- (NSArray*)allKeys ;
- (NSArray*)allValues ;
- (NSUInteger)count ;
@end
