//
//  GSPartProperty.h
//  GlyphsCore
//
//  Created by Georg Seifert on 29.09.14.
//  Copyright (c) 2014 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "GSContainerProtocol.h"

@interface GSPartProperty : NSObject
@property (strong, nonatomic) NSString* name;
@property (strong, nonatomic) NSString* bottomName;
@property (assign, nonatomic) NSInteger bottomValue;
@property (strong, nonatomic) NSString* topName;
@property (assign, nonatomic) NSInteger topValue;
@property (assign, nonatomic) CGFloat pieceValue;
@property (weak, nonatomic) id <GSContainerProtocol> component;
- (instancetype) initWithDict:(NSDictionary*)Dict;
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;
- (NSDictionary*)propertyList ;
@end
