//
//  GSPathOperator.h
//  PathOperations
//
//  Created by Georg Seifert on 03.03.14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSLayer;
@class GSPath;

CGFloat GSMultiplicator(NSPoint a, NSPoint b, NSPoint c);

typedef NS_ENUM(NSInteger, GSPathOperations) {
	GSRemoveOverlap,
	GSSubtract,
	
} ;

@interface GSPathOperator : NSObject {
	
}

- (BOOL) operation:(GSPathOperations) Operations toLayer:(GSLayer*)Layer checkSelection:(BOOL)checkSelection error:(NSError**) error;
- (BOOL) removeOverlapPaths:(NSMutableArray *)Paths error:(NSError *__autoreleasing*)error debug:(BOOL)Debug;
- (BOOL) removeOverlapPaths:(NSMutableArray *)Paths error:(NSError *__autoreleasing*)error;
- (BOOL) subtractPaths:(NSMutableArray *)SubstactPaths from:(NSMutableArray *)Paths error:(NSError *__autoreleasing*)error debug:(BOOL)Debug;
- (BOOL) subtractPaths:(NSMutableArray *)SubstactPaths from:(NSMutableArray *)Paths error:(NSError *__autoreleasing*)error;
- (BOOL) intersectPaths:(NSMutableArray *)SubstactPaths from:(NSMutableArray *)Paths error:(NSError *__autoreleasing*)error ;
+ (NSArray *)segmentsFromPaths:(NSArray *)Paths ;
- (void)addIntersections:(NSMutableArray *)Segments;
@end
