//
//  GSPathSegment.h
//  PathOperations
//
//  Created by Georg Seifert on 03.03.14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//


typedef struct {
	NSPoint elements[4];
	uint8 count;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
} _GSSegment;

void _GSSegmentUpdateBounds(_GSSegment*S);

@interface GSPathSegment : NSObject <NSCopying> {
	
@public
	NSPoint elements[4];
	uint8 count;
	BOOL black; // 0 == white(counter) 1 == black
	CGFloat minX;
	CGFloat maxX;
	CGFloat minY;
	CGFloat maxY;
}
- (instancetype) initWithLinePoint1:(NSPoint)P1 point2:(NSPoint)P2 direction:(BOOL) Black;
- (instancetype) initWithCurvePoint1:(NSPoint)P1 point2:(NSPoint)P2 point3:(NSPoint)P3 point4:(NSPoint)P4 direction:(BOOL) Black;
- (instancetype) initWithSegment:(_GSSegment*)S ;
- (_GSSegment)segmentStruct ;
- (void) updateBounds;
- (void) reverse;
- (NSComparisonResult) compare:(GSPathSegment*) otherObject;
- (BOOL) isEqualToSegment:(GSPathSegment*) otherSegment;
- (NSPoint) middlePointRight;
- (NSPoint) middlePointLeft;
- (void) splitFirstHalf:(GSPathSegment**)left secondHalf:(GSPathSegment**)right;
- (bool) intersects:(GSPathSegment*) OtherSegment;
- (double**) intersections:(GSPathSegment*) OtherSegment NS_RETURNS_INNER_POINTER;
@end
