//
//  GSSelectGlyphsDialogController.h
//  GlyphsKit
//
//  Created by Georg Seifert on 13/09/14.
//  Copyright (c) 2014 Brandon Walkin. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFindGlyphSortDescriptor;

@interface GSSelectGlyphsDialogController : NSWindowController {
	NSArray* selectedGlyphs;
	GSFindGlyphSortDescriptor* _findGlyphSortDescriptor;
}

@property (strong, nonatomic) NSArray* selectedGlyphs;
@property (nonatomic, weak) IBOutlet NSSearchField* glyphsSelectSearchField;
@property (nonatomic, weak) IBOutlet NSArrayController* glyphListController;
@property (nonatomic, weak) IBOutlet NSTableView* glyphListTableView;

- (NSUInteger)runModal;

- (void)setMasterID:(NSString*)MasterID;

- (void)setTitle:(NSString*)Title;

- (void)setContent:(NSArray*)Content;

- (void)setSearch:(NSString*)Search;

- (IBAction)findOK:(id)sender;

- (IBAction)findChanged:(id)sender;

- (IBAction)modalCancel:(id)sender;

@end
