//
//  GSToolSelect.h
//  GlyphsCore
//
//  Created by Georg Seifert on 16.04.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GlyphsPathPlugin.h>

@class GSElement;
@class GSHandle;
@class GSPartsPropertiesViewController;

@interface GSToolSelect : GlyphsPathPlugin {
	NSRect auswahlRect;
	NSCursor* elementCursor;
	CGFloat grabbedPathTime;
	NSMutableDictionary* selectionBoundsHandles;
	GSHandle* _referenceHandle;
}
//@property (nonatomic, retain) GSHandle *selectionBoundsHandle;

@property (nonatomic, retain) GSPartsPropertiesViewController * partsProperties;

- (void)mouseDoubleDown:(NSEvent*)theEvent;

- (void)selectGlyph:(NSEvent*)theEvent;

- (void)selectAtPoint:(NSPoint)Point withModifier:(NSUInteger)modifierFlag;

- (void)selectInRect:(NSRect)Rect withModifier:(NSUInteger)modifierFlag;

- (GSElement*)elementAtPoint:(NSPoint)Loc atLayer:(GSLayer*)Layer;

//- (void) selectNext ;
- (void)insertTab:(id)sender;

- (void)insertBacktab:(id)sender;

- (IBAction)reconnectNodes:(id)sender;

- (IBAction)decomposeComponent:(id)sender;

- (IBAction)makeGlobal:(id)sender;

- (IBAction)setBackgroundImageCropToMetrics:(id)sender;

- (IBAction)componentFromSelection:(id)sender;

- (GSHandle*)handleForPoint:(NSPoint)aPoint atBounds:(NSRect)Bounds;
@end
