//
//  GSWindowControllerProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.03.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Foundation/Foundation.h>

@class GSLayer;
@protocol GlyphsTool;
@protocol GlyphsToolEvent;
@protocol GSGlyphEditViewControllerProtocol;

@protocol GSWindowControllerProtocol

@property (unsafe_unretained, nonatomic) NSResponder <GlyphsTool, GlyphsToolEvent>* toolEventDelegate;
@property (nonatomic) BOOL ShiftKey, AltKey, CtrlKey, CommandKey, SpaceKey;
@property (nonatomic) NSUInteger lastSelectToolIndex;
@property (nonatomic) NSUInteger selectedToolIndex;
@property (unsafe_unretained, nonatomic) IBOutlet NSArrayController* glyphListController;

- (GSLayer*)activeLayer;

- (NSViewController <GSGlyphEditViewControllerProtocol>*)activeEditViewController;

- (NSUInteger)masterIndex;

- (void)setToolForClass:(Class)aClass;

#ifndef GLYPHS_LITE

- (void)showFontInfoWindowWithTabSelected:(NSUInteger)TabIndex;

#endif

@end
