//
//  GlyphsPaletteProtocol.h
//  PalettePlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol GSWindowControllerProtocol;

/*! \brief GlyphsPalette: The protocol defining the palette plugin interface
 \ingroup common
 The protocol defining the palette plugin interface.
 */
@protocol GlyphsPalette

@property (nonatomic, weak) NSWindowController <GSWindowControllerProtocol>* windowController;
//! The interface version.
@property (readonly, nonatomic) NSUInteger interfaceVersion;
//! The title of the plugin.
@property (readonly, nonatomic) NSString* title;
//! the view to display in the palette.
@property (readonly, strong, nonatomic) NSView* theView;
//! the minimal height of the view.
@property (readonly, nonatomic) NSInteger minHeight;
//! the maximal height of the view.
@property (readonly, nonatomic) NSInteger maxHeight;
@optional
@property (assign, nonatomic) NSUInteger currentHeight;

@end