//
//  InspectorViewGlyphController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSInspectorViewController.h"

@class GSLayer;
@class GSInspectorView;

@interface InspectorViewGlyphController : GSInspectorViewController {
	GSLayer* __unsafe_unretained _previousLayer;
	GSLayer* __unsafe_unretained _nextLayer;

	NSImage* exeption;
	NSImage* noExeption;
	NSImage* rightTransferValue;
	NSImage* leftTransferValue;
}

@property (unsafe_unretained, nonatomic) GSLayer* previousLayer;
@property (unsafe_unretained, nonatomic) GSLayer* nextLayer;
@property (nonatomic, weak) IBOutlet NSButton* leftExeptionButton;
@property (nonatomic, weak) IBOutlet NSButton* rightExeptionButton;
@property (nonatomic, weak) IBOutlet NSTextField* nameField;
@property (nonatomic, weak) IBOutlet NSTextField* unicodeField;
@property (nonatomic, weak) IBOutlet NSTextField* leftMetricsLabel;
@property (nonatomic, weak) IBOutlet NSTextField* leftMetricsField;
@property (nonatomic, weak) IBOutlet NSButton* leftMetricsSyncButton;
@property (nonatomic, weak) IBOutlet NSTextField* widthLabel;
@property (nonatomic, weak) IBOutlet NSTextField* widthField;
@property (nonatomic, weak) IBOutlet NSButton* widthMetricsSyncButton;
@property (nonatomic, weak) IBOutlet NSTextField* rightMetricsLabel;
@property (nonatomic, weak) IBOutlet NSTextField* rightMetricsField;
@property (nonatomic, weak) IBOutlet NSButton* rightMetricsSyncButton;
@property (nonatomic, weak) IBOutlet NSTextField* leftKerningField;
@property (nonatomic, weak) IBOutlet NSTextField* leftGroupField;
@property (nonatomic, weak) IBOutlet NSTextField* rightGroupField;
@property (nonatomic, weak) IBOutlet NSTextField* rightKerningField;
@property (nonatomic, weak) IBOutlet NSButton* showInUnicodeCheckerButton;
@property (nonatomic, weak) IBOutlet NSPopUpButton* colorLabelPopup;
@property (nonatomic, weak) IBOutlet GSInspectorView* nameBackgroundView;

- (IBAction)showInUnicodeChecker:(id)sender;

#ifndef GLYPHS_VIEWER

- (void)setAlternateButtons:(NSNotification*)theNotifivation;

- (IBAction)setName:(id)sender;

- (IBAction)setLeftMetricsKey:(id)sender;

- (IBAction)setRightMetricsKey:(id)sender;

- (IBAction)setWidth:(id)sender;

- (IBAction)setLeftKerning:(id)sender;

- (IBAction)setLeftGroup:(id)sender;

- (IBAction)setLeftExeption:(id)sender;

- (IBAction)setRightKerning:(id)sender;

- (IBAction)setRightGroup:(id)sender;

- (IBAction)setRightExeption:(id)sender;
#endif
@end
