//
//  InspectorViewKerningController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 12.02.12.
//  Copyright (c) 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSInspectorViewController.h"

@class GSLayer;

@interface InspectorViewKerningController : GSInspectorViewController {
	GSLayer* __unsafe_unretained _previousLayer;
	GSLayer* __unsafe_unretained _nextLayer;
	IBOutlet NSButton* leftExeptionButton;
	IBOutlet NSButton* rightExeptionButton;

	IBOutlet NSTextField* leftKerningField;
	IBOutlet NSTextField* leftGroupField;
	IBOutlet NSTextField* rightGroupField;
	IBOutlet NSTextField* rightKerningField;

	NSImage* exeption;
	NSImage* noExeption;
	NSImage* rightTransferValue;
	NSImage* leftTransferValue;
}

@property (unsafe_unretained, nonatomic) GSLayer* previousLayer;
@property (unsafe_unretained, nonatomic) GSLayer* nextLayer;

- (void)setAlternateButtons:(NSNotification*)theNotifivation;

- (IBAction)setLeftKerning:(id)sender;

- (IBAction)setLeftGroup:(id)sender;

- (IBAction)setLeftExeption:(id)sender;

- (IBAction)setRightKerning:(id)sender;

- (IBAction)setRightGroup:(id)sender;

- (IBAction)setRightExeption:(id)sender;
@end
