//
//  NSDictionary_KeyPath.h
//  GlyphsFileFormatOTF
//
//  Created by Georg Seifert on 15.10.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MGOrderedDictionary.h"

@interface NSDictionary (GetObjectForKeys)
/**
You have to be carful with nil arguments.
*/
- (id)objectForKeys:(id)firstObj, ... NS_REQUIRES_NIL_TERMINATION;

- (id)objectForKeysInArray:(NSArray*)inKeys;

- (id)objectForKeyPath:(NSString*)inKeyPath;
@end

@interface NSMutableDictionary (SetObjectForKeysInArray)

- (void)setObject:(id)inValue forKeysInArray:(NSArray*)inKeys;

@end

@interface MGOrderedDictionary (SetObjectOrderedForKeysInArray)

- (void)setObject:(id)inValue forKeysInArray:(NSArray*)inKeys;

@end
