//
//  NSStringHelpers.h
//  GlyphsCore
//
//  Created by Georg Seifert on 06.08.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

NSString* GSFloatToStringWithPrecision(CGFloat Float, int precision);

void GSFloatToStringWithPrecisionToBuffer(char **buffer, CGFloat Float, int precision);

NSString* GSFloatToStringWithPrecisionMin(CGFloat Float, int precision, int minPrecision);

NSString* GSFloatToStringWithPrecisionLocalized(CGFloat Float, int precision);

NSString* GSFloatToStringLocalized(CGFloat Float);

NSString* GSFloatToString(CGFloat Float);

@interface NSString (UUID)

+ (NSString*)UUID;

+ (NSString*)hexStringFromInt:(NSInteger)Integer;

- (int)hexStringToInt;

- (NSString*)ascciString;

- (NSUInteger)countOfChar:(char)Char;

- (NSString*)absolutePathFromBaseDirPath:(NSString*)baseDirPath;

- (NSString*)relativePathFromBaseDirPath:(NSString*)baseDirPath;

- (NSString*)encodeForPlist;
@end

BOOL writeKeyValueString(FILE* File, NSString* Key, NSString* Value);

BOOL writeKeyValueInt(FILE* File, NSString* Key, int Value);

BOOL writeKeyValueFloat(FILE* File, NSString* Key, CGFloat Value);