/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;
import java.util.List;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CP {
    private static final String fSTART_CHAR = "[";
    private static final String fEND_CHAR = "]";
    private static final String fSEPARATOR = ", ";
    private static final String fNULL = "null";

    public static String forURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return string2;
    }

    public static String forHTMLTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\\') {
                stringBuffer.append("&#092;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    String URLEncode(String string) {
        String string2 = new String();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 0) continue;
                string2 = byArray[i] == 32 ? string2 + '+' : string2 + (char)byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.length() < 1) {
            return "";
        }
        for (int i = 0; i < string.length() && (i = string.indexOf(string2, i)) >= 0; i += string3.length()) {
            string = string.substring(0, i) + string3 + string.substring(i + string2.length(), string.length());
        }
        return string;
    }

    public static int parseHex(String string) {
        int n = string.length();
        switch (n) {
            case 8: {
                break;
            }
            case 6: {
                string = "ff" + string;
                break;
            }
            default: {
                string = "ff000000";
            }
        }
        int n2 = new Integer(Integer.parseInt(string.substring(0, 2), 16));
        int n3 = new Integer(Integer.parseInt(string.substring(2, 4), 16));
        int n4 = new Integer(Integer.parseInt(string.substring(4, 6), 16));
        int n5 = new Integer(Integer.parseInt(string.substring(6, 8), 16));
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static String intToString(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        String string = Integer.toHexString(n2).length() == 1 ? "0" + Integer.toHexString(n2) : Integer.toHexString(n2);
        String string2 = Integer.toHexString(n3).length() == 1 ? "0" + Integer.toHexString(n3) : Integer.toHexString(n3);
        String string3 = Integer.toHexString(n4).length() == 1 ? "0" + Integer.toHexString(n4) : Integer.toHexString(n4);
        String string4 = Integer.toHexString(n5).length() == 1 ? "0" + Integer.toHexString(n5) : Integer.toHexString(n5);
        return string + string2 + string3 + string4;
    }

    @Deprecated
    protected boolean save(ControlP5 controlP5, String string) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    public static String arrayToString(Object object) {
        if (object == null) {
            return fNULL;
        }
        CP.checkObjectIsArray(object);
        StringBuilder stringBuilder = new StringBuilder(fSTART_CHAR);
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (CP.isNonNullArray(object2)) {
                stringBuilder.append(CP.arrayToString(object2));
            } else {
                stringBuilder.append(object2);
            }
            if (CP.isLastItem(i, n)) continue;
            stringBuilder.append(fSEPARATOR);
        }
        stringBuilder.append(fEND_CHAR);
        return stringBuilder.toString();
    }

    private static void checkObjectIsArray(Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    private static boolean isNonNullArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    private static boolean isLastItem(int n, int n2) {
        return n == n2 - 1;
    }

    protected static String formatGetClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.toString().startsWith("class ") ? clazz.toString().substring("class ".length()) : clazz.toString();
    }

    public static boolean inside(int[] nArray, PVector pVector) {
        return CP.inside(nArray, pVector.x, pVector.y);
    }

    public static boolean inside(int[] nArray, float f, float f2) {
        if (nArray.length == 4) {
            return f > (float)nArray[0] && f < (float)nArray[2] && f2 > (float)nArray[1] && f2 < (float)nArray[3];
        }
        return false;
    }

    public static String encodeBase64(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; i += 3) {
            stringBuffer.append(CP.encodeBlock(byArray, i));
        }
        return stringBuffer.toString();
    }

    protected static char[] encodeBlock(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = byArray.length - n - 1;
        int n6 = n5 >= 2 ? 2 : n5;
        for (int i = 0; i <= n6; ++i) {
            n3 = byArray[n + i];
            n2 = n3 < 0 ? n3 + 256 : n3;
            n4 += n2 << 8 * (2 - i);
        }
        char[] cArray = new char[4];
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = n4 >>> 6 * (3 - n3) & 0x3F;
            cArray[n3] = CP.getBase64Char(n2);
        }
        if (n5 < 1) {
            cArray[2] = 61;
        }
        if (n5 < 2) {
            cArray[3] = 61;
        }
        return cArray;
    }

    static char getBase64Char(int n) {
        if (n >= 0 && n <= 25) {
            return (char)(65 + n);
        }
        if (n >= 26 && n <= 51) {
            return (char)(97 + (n - 26));
        }
        if (n >= 52 && n <= 61) {
            return (char)(48 + (n - 52));
        }
        if (n == 62) {
            return '+';
        }
        if (n == 63) {
            return '/';
        }
        return '?';
    }

    public static byte[] decodeBase64(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (string.charAt(n2) == '=') {
            ++n;
            --n2;
        }
        n2 = string.length() * 6 / 8 - n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < string.length(); i += 4) {
            int n4 = (CP.getBase64Value(string.charAt(i)) << 18) + (CP.getBase64Value(string.charAt(i + 1)) << 12) + (CP.getBase64Value(string.charAt(i + 2)) << 6) + CP.getBase64Value(string.charAt(i + 3));
            for (int j = 0; j < 3 && n3 + j < byArray.length; ++j) {
                byArray[n3 + j] = (byte)(n4 >> 8 * (2 - j) & 0xFF);
            }
            n3 += 3;
        }
        return byArray;
    }

    static int getBase64Value(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        return -1;
    }

    public static int getBit(int n, int n2) {
        int n3 = 1 << n2;
        return (n & n3) > 0 ? 1 : 0;
    }

    public static byte setHigh(byte by, int n) {
        return (byte)(by | 1 << n);
    }

    public static byte setLow(byte by, int n) {
        return (byte)(by & ~(1 << n));
    }

    public static byte[] intToByteArray(int n) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)(n & 0xFF);
        byArray[0] = (byte)(n >> 8 & 0xFF);
        return byArray;
    }

    public static int byteArrayToInt(byte[] byArray) {
        int n = 0;
        for (int i = 0; i < 2; ++i) {
            int n2 = (1 - i) * 8;
            n += (byArray[i] & 0xFF) << n2;
        }
        return n;
    }

    static String join(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : list) {
            stringBuilder.append(string2).append(string);
        }
        return stringBuilder.toString();
    }
}

