/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerView;
import controlP5.Label;
import controlP5.Tab;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toggle
extends Controller<Toggle> {
    protected int cnt;
    protected boolean isOn = false;
    protected float internalValue = -1.0f;
    public static int autoWidth = 39;
    public static int autoHeight = 19;
    protected PVector autoSpacing = new PVector(10.0f, 20.0f, 0.0f);

    public Toggle(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 0.0f, 0.0f, autoWidth, autoHeight);
        controlP5.register(controlP5.papplet, string, this);
    }

    public Toggle(ControlP5 controlP5, Tab tab, String string, float f, float f2, float f3, int n, int n2) {
        super(controlP5, tab, string, f2, f3, n, n2);
        this._myValue = f;
        this._myCaptionLabel.align(37, 13).setPadding(0, Label.paddingY);
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet pApplet) {
        pApplet.pushMatrix();
        pApplet.translate(this.position.x, this.position.y);
        this._myControllerView.display(pApplet, this);
        pApplet.popMatrix();
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        this.setState(!this.isOn);
        this.isActive = false;
    }

    @Override
    public Toggle setValue(float f) {
        if (f == 0.0f) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setValue(boolean bl) {
        this.setValue(bl ? 1.0f : 0.0f);
        return this;
    }

    @Override
    public Toggle update() {
        return this.setValue(this._myValue);
    }

    public Toggle setState(boolean bl) {
        this.isOn = bl;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
        this.broadcast(2);
        return this;
    }

    public boolean getState() {
        return this.isOn;
    }

    protected void deactivate() {
        this.isOn = false;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    protected void activate() {
        this.isOn = true;
        this._myValue = !this.isOn ? 0.0f : 1.0f;
    }

    public Toggle toggle() {
        if (this.isOn) {
            this.setState(false);
        } else {
            this.setState(true);
        }
        return this;
    }

    public Toggle setMode(int n) {
        this.updateDisplayMode(n);
        return this;
    }

    @ControlP5.Invisible
    public void setInternalValue(float f) {
        this.internalValue = f;
    }

    @ControlP5.Invisible
    public float internalValue() {
        return this.internalValue;
    }

    @Override
    public Toggle linebreak() {
        this.cp5.linebreak(this, true, autoWidth, autoHeight, this.autoSpacing);
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Toggle updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new ToggleView();
                break;
            }
            case 1: {
                this._myControllerView = new ToggleImageView();
                break;
            }
            case 100: {
                this._myControllerView = new ToggleSwitchView();
                break;
            }
        }
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleSwitchView
    implements ControllerView<Toggle> {
        ToggleSwitchView() {
        }

        @Override
        public void display(PApplet pApplet, Toggle toggle) {
            pApplet.fill(Toggle.this.color.getBackground());
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            pApplet.fill(Toggle.this.color.getActive());
            if (Toggle.this.isOn) {
                pApplet.rect(0.0f, 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            } else {
                pApplet.rect((float)((Toggle.this.width % 2 == 0 ? 0 : 1) + Toggle.this.width / 2), 0.0f, (float)(Toggle.this.width / 2), (float)Toggle.this.height);
            }
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(pApplet, 0, 0, toggle);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleImageView
    implements ControllerView<Toggle> {
        ToggleImageView() {
        }

        @Override
        public void display(PApplet pApplet, Toggle toggle) {
            if (Toggle.this.isActive) {
                pApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else if (Toggle.this.isOn) {
                pApplet.image(Toggle.this.availableImages[2] ? Toggle.this.images[2] : Toggle.this.images[0], 0.0f, 0.0f);
            } else {
                pApplet.image(Toggle.this.images[0], 0.0f, 0.0f);
            }
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToggleView
    implements ControllerView<Toggle> {
        ToggleView() {
        }

        @Override
        public void display(PApplet pApplet, Toggle toggle) {
            if (Toggle.this.isActive) {
                pApplet.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getForeground());
            } else {
                pApplet.fill(Toggle.this.isOn ? Toggle.this.color.getActive() : Toggle.this.color.getBackground());
            }
            pApplet.rect(0.0f, 0.0f, (float)Toggle.this.width, (float)Toggle.this.height);
            if (Toggle.this.isLabelVisible) {
                Toggle.this._myCaptionLabel.draw(pApplet, 0, 0, toggle);
            }
        }
    }
}

