/*
 * Decompiled with CFR 0.152.
 */
package org.processing.wiki.triangulate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.processing.wiki.triangulate.Edge;
import org.processing.wiki.triangulate.Triangle;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Triangulate {
    private static boolean circumCircle(PVector pVector, Triangle triangle, PVector pVector2) {
        if (PApplet.abs((float)(triangle.p1.y - triangle.p2.y)) < 1.0E-4f && PApplet.abs((float)(triangle.p2.y - triangle.p3.y)) < 1.0E-4f) {
            System.err.println("CircumCircle: Points are coincident.");
            return false;
        }
        if (PApplet.abs((float)(triangle.p2.y - triangle.p1.y)) < 1.0E-4f) {
            float f = -(triangle.p3.x - triangle.p2.x) / (triangle.p3.y - triangle.p2.y);
            float f2 = (triangle.p2.x + triangle.p3.x) / 2.0f;
            float f3 = (triangle.p2.y + triangle.p3.y) / 2.0f;
            pVector2.x = (triangle.p2.x + triangle.p1.x) / 2.0f;
            pVector2.y = f * (pVector2.x - f2) + f3;
        } else if (PApplet.abs((float)(triangle.p3.y - triangle.p2.y)) < 1.0E-4f) {
            float f = -(triangle.p2.x - triangle.p1.x) / (triangle.p2.y - triangle.p1.y);
            float f4 = (triangle.p1.x + triangle.p2.x) / 2.0f;
            float f5 = (triangle.p1.y + triangle.p2.y) / 2.0f;
            pVector2.x = (triangle.p3.x + triangle.p2.x) / 2.0f;
            pVector2.y = f * (pVector2.x - f4) + f5;
        } else {
            float f = -(triangle.p2.x - triangle.p1.x) / (triangle.p2.y - triangle.p1.y);
            float f6 = -(triangle.p3.x - triangle.p2.x) / (triangle.p3.y - triangle.p2.y);
            float f7 = (triangle.p1.x + triangle.p2.x) / 2.0f;
            float f8 = (triangle.p2.x + triangle.p3.x) / 2.0f;
            float f9 = (triangle.p1.y + triangle.p2.y) / 2.0f;
            float f10 = (triangle.p2.y + triangle.p3.y) / 2.0f;
            pVector2.x = (f * f7 - f6 * f8 + f10 - f9) / (f - f6);
            pVector2.y = f * (pVector2.x - f7) + f9;
        }
        float f = triangle.p2.x - pVector2.x;
        float f11 = triangle.p2.y - pVector2.y;
        float f12 = f * f + f11 * f11;
        pVector2.z = PApplet.sqrt((float)f12);
        f = pVector.x - pVector2.x;
        f11 = pVector.y - pVector2.y;
        float f13 = f * f + f11 * f11;
        return f13 <= f12;
    }

    public static ArrayList<Triangle> triangulate(ArrayList<PVector> arrayList) {
        Object object;
        Collections.sort(arrayList, new XComparator());
        float f = arrayList.get((int)0).x;
        float f2 = arrayList.get((int)0).y;
        float f3 = f;
        float f4 = f2;
        for (PVector pVector : arrayList) {
            if (pVector.x < f) {
                f = pVector.x;
            }
            if (pVector.x > f3) {
                f3 = pVector.x;
            }
            if (pVector.y < f2) {
                f2 = pVector.y;
            }
            if (!(pVector.y > f4)) continue;
            f4 = pVector.y;
        }
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float f7 = f5 > f6 ? f5 : f6;
        float f8 = (f3 + f) / 2.0f;
        float f9 = (f4 + f2) / 2.0f;
        ArrayList<Triangle> arrayList2 = new ArrayList<Triangle>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Triangle triangle = new Triangle();
        triangle.p1 = new PVector(f8 - 2.0f * f7, f9 - f7, 0.0f);
        triangle.p2 = new PVector(f8, f9 + 2.0f * f7, 0.0f);
        triangle.p3 = new PVector(f8 + 2.0f * f7, f9 - f7, 0.0f);
        arrayList2.add(triangle);
        ArrayList<Edge> arrayList3 = new ArrayList<Edge>();
        for (PVector pVector : arrayList) {
            int n;
            Object object2;
            int n2;
            arrayList3.clear();
            object = new PVector();
            for (n2 = arrayList2.size() - 1; n2 >= 0; --n2) {
                object2 = arrayList2.get(n2);
                if (hashSet.contains(object2)) continue;
                n = Triangulate.circumCircle(pVector, (Triangle)object2, (PVector)object);
                if (((PVector)object).x + ((PVector)object).z < pVector.x) {
                    hashSet.add(object2);
                }
                if (n == 0) continue;
                arrayList3.add(new Edge(((Triangle)object2).p1, ((Triangle)object2).p2));
                arrayList3.add(new Edge(((Triangle)object2).p2, ((Triangle)object2).p3));
                arrayList3.add(new Edge(((Triangle)object2).p3, ((Triangle)object2).p1));
                arrayList2.remove(n2);
            }
            for (n2 = 0; n2 < arrayList3.size() - 1; ++n2) {
                object2 = (Edge)arrayList3.get(n2);
                for (n = n2 + 1; n < arrayList3.size(); ++n) {
                    Edge edge = (Edge)arrayList3.get(n);
                    if (((Edge)object2).p1 == edge.p2 && ((Edge)object2).p2 == edge.p1) {
                        ((Edge)object2).p1 = null;
                        ((Edge)object2).p2 = null;
                        edge.p1 = null;
                        edge.p2 = null;
                    }
                    if (((Edge)object2).p1 != edge.p1 || ((Edge)object2).p2 != edge.p2) continue;
                    ((Edge)object2).p1 = null;
                    ((Edge)object2).p2 = null;
                    edge.p1 = null;
                    edge.p2 = null;
                }
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                object2 = (Edge)arrayList3.get(n2);
                if (((Edge)object2).p1 == null || ((Edge)object2).p2 == null) continue;
                arrayList2.add(new Triangle(((Edge)object2).p1, ((Edge)object2).p2, pVector));
            }
        }
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            object = arrayList2.get(i);
            if (!((Triangle)object).sharesVertex(triangle)) continue;
            arrayList2.remove(i);
        }
        return arrayList2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XComparator
    implements Comparator<PVector> {
        private XComparator() {
        }

        @Override
        public int compare(PVector pVector, PVector pVector2) {
            if (pVector.x < pVector2.x) {
                return -1;
            }
            if (pVector.x > pVector2.x) {
                return 1;
            }
            return 0;
        }
    }
}

