/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.util;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;

public class DruidDataSourceUtils {
    private static final Log LOG = LogFactory.getLog(DruidDataSourceUtils.class);

    public static String getUrl(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getUrl();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getUrl", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (String)obj;
        }
        catch (Exception e) {
            LOG.error("getUrl error", e);
            return null;
        }
    }

    public static long getID(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getID();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getID", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Long)obj;
        }
        catch (Exception e) {
            LOG.error("getID error", e);
            return -1L;
        }
    }

    public static String getName(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getName();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getName", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (String)obj;
        }
        catch (Exception e) {
            LOG.error("getUrl error", e);
            return null;
        }
    }

    public static ObjectName getObjectName(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getObjectName();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getObjectName", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (ObjectName)obj;
        }
        catch (Exception e) {
            LOG.error("getObjectName error", e);
            return null;
        }
    }

    public static Object getSqlStat(Object druidDatasource, int sqlId) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getSqlStat(sqlId);
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getSqlStat", Integer.TYPE);
            Object obj = method.invoke(druidDatasource, sqlId);
            return obj;
        }
        catch (Exception e) {
            LOG.error("getSqlStat error", e);
            return null;
        }
    }

    public static boolean isRemoveAbandoned(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).isRemoveAbandoned();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("isRemoveAbandoned", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Boolean)obj;
        }
        catch (Exception e) {
            LOG.error("isRemoveAbandoned error", e);
            return false;
        }
    }

    public static Map<String, Object> getStatDataForMBean(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getStatDataForMBean();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getStatDataForMBean", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getStatDataForMBean error", e);
            return null;
        }
    }

    public static Map<String, Object> getStatData(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getStatData();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getStatData", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getStatData error", e);
            return null;
        }
    }

    public static Map getSqlStatMap(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getSqlStatMap();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getSqlStatMap", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getSqlStatMap error", e);
            return null;
        }
    }

    public static Map<String, Object> getWallStatMap(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getWallStatMap();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getWallStatMap", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (Map)obj;
        }
        catch (Exception e) {
            LOG.error("getWallStatMap error", e);
            return null;
        }
    }

    public static List<Map<String, Object>> getPoolingConnectionInfo(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getPoolingConnectionInfo();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getPoolingConnectionInfo", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getPoolingConnectionInfo error", e);
            return null;
        }
    }

    public static List<String> getActiveConnectionStackTrace(Object druidDatasource) {
        if (druidDatasource.getClass() == DruidDataSource.class) {
            return ((DruidDataSource)druidDatasource).getActiveConnectionStackTrace();
        }
        try {
            Method method = druidDatasource.getClass().getMethod("getActiveConnectionStackTrace", new Class[0]);
            Object obj = method.invoke(druidDatasource, new Object[0]);
            return (List)obj;
        }
        catch (Exception e) {
            LOG.error("getActiveConnectionStackTrace error", e);
            return null;
        }
    }
}

