/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.core.Controller;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class Routes {
    private final Map<String, Class<? extends Controller>> map = new HashMap<String, Class<? extends Controller>>();
    private final Map<String, String> viewPathMap = new HashMap<String, String>();
    private static String baseViewPath;

    public abstract void config();

    public Routes add(Routes routes) {
        if (routes != null) {
            routes.config();
            this.map.putAll(routes.map);
            this.viewPathMap.putAll(routes.viewPathMap);
        }
        return this;
    }

    public Routes add(String controllerKey, Class<? extends Controller> controllerClass, String viewPath) {
        if (controllerKey == null) {
            throw new IllegalArgumentException("The controllerKey can not be null");
        }
        if ("".equals(controllerKey = controllerKey.trim())) {
            throw new IllegalArgumentException("The controllerKey can not be blank");
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException("The controllerClass can not be null");
        }
        if (!controllerKey.startsWith("/")) {
            controllerKey = "/" + controllerKey;
        }
        if (this.map.containsKey(controllerKey)) {
            throw new IllegalArgumentException("The controllerKey already exists: " + controllerKey);
        }
        this.map.put(controllerKey, controllerClass);
        if (viewPath == null || "".equals(viewPath.trim())) {
            viewPath = controllerKey;
        }
        if (!(viewPath = viewPath.trim()).startsWith("/")) {
            viewPath = "/" + viewPath;
        }
        if (!viewPath.endsWith("/")) {
            viewPath = String.valueOf(viewPath) + "/";
        }
        if (baseViewPath != null) {
            viewPath = String.valueOf(baseViewPath) + viewPath;
        }
        this.viewPathMap.put(controllerKey, viewPath);
        return this;
    }

    public Routes add(String controllerkey, Class<? extends Controller> controllerClass) {
        return this.add(controllerkey, controllerClass, controllerkey);
    }

    public Set<Map.Entry<String, Class<? extends Controller>>> getEntrySet() {
        return this.map.entrySet();
    }

    public String getViewPath(String key) {
        return this.viewPathMap.get(key);
    }

    static void setBaseViewPath(String baseViewPath) {
        if (baseViewPath == null) {
            throw new IllegalArgumentException("The baseViewPath can not be null");
        }
        if ("".equals(baseViewPath = baseViewPath.trim())) {
            throw new IllegalArgumentException("The baseViewPath can not be blank");
        }
        if (!baseViewPath.startsWith("/")) {
            baseViewPath = "/" + baseViewPath;
        }
        if (baseViewPath.endsWith("/")) {
            baseViewPath = baseViewPath.substring(0, baseViewPath.length() - 1);
        }
        Routes.baseViewPath = baseViewPath;
    }
}

