/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ActionInvocation {
    private Controller controller;
    private Interceptor[] inters;
    private Action action;
    private int index = 0;
    private static final Object[] NULL_ARGS = new Object[0];

    protected ActionInvocation() {
    }

    ActionInvocation(Action action, Controller controller) {
        this.controller = controller;
        this.inters = action.getInterceptors();
        this.action = action;
    }

    public void invoke() {
        if (this.index < this.inters.length) {
            this.inters[this.index++].intercept(this);
        } else if (this.index++ == this.inters.length) {
            try {
                this.action.getMethod().invoke((Object)this.controller, NULL_ARGS);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getTargetException();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Controller getController() {
        return this.controller;
    }

    public String getActionKey() {
        return this.action.getActionKey();
    }

    public String getControllerKey() {
        return this.action.getControllerKey();
    }

    public Method getMethod() {
        return this.action.getMethod();
    }

    public String getMethodName() {
        return this.action.getMethodName();
    }

    public String getViewPath() {
        return this.action.getViewPath();
    }
}

