/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Interceptor;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Routes;
import com.jfinal.core.Action;
import com.jfinal.core.ActionKey;
import com.jfinal.core.Controller;
import com.jfinal.core.InterceptorBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ActionMapping {
    private static final String SLASH = "/";
    private Routes routes;
    private Interceptors interceptors;
    private final Map<String, Action> mapping = new HashMap<String, Action>();

    ActionMapping(Routes routes, Interceptors interceptors) {
        this.routes = routes;
        this.interceptors = interceptors;
    }

    private Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        Method[] methodArray = methods = Controller.class.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getParameterTypes().length == 0) {
                excludedMethodName.add(m.getName());
            }
            ++n2;
        }
        return excludedMethodName;
    }

    void buildActionMapping() {
        this.mapping.clear();
        Set<String> excludedMethodName = this.buildExcludedMethodName();
        InterceptorBuilder interceptorBuilder = new InterceptorBuilder();
        Interceptor[] defaultInters = this.interceptors.getInterceptorArray();
        interceptorBuilder.addToInterceptorsMap(defaultInters);
        for (Map.Entry<String, Class<? extends Controller>> entry : this.routes.getEntrySet()) {
            Method[] methods;
            Class<? extends Controller> controllerClass = entry.getValue();
            Interceptor[] controllerInters = interceptorBuilder.buildControllerInterceptors(controllerClass);
            Method[] methodArray = methods = controllerClass.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String methodName = method.getName();
                if (!excludedMethodName.contains(methodName) && method.getParameterTypes().length == 0) {
                    Action action;
                    String actionKey;
                    Interceptor[] methodInters = interceptorBuilder.buildMethodInterceptors(method);
                    Interceptor[] actionInters = interceptorBuilder.buildActionInterceptors(defaultInters, controllerInters, controllerClass, methodInters, method);
                    String controllerKey = entry.getKey();
                    ActionKey ak = method.getAnnotation(ActionKey.class);
                    if (ak != null) {
                        actionKey = ak.value().trim();
                        if ("".equals(actionKey)) {
                            throw new IllegalArgumentException(String.valueOf(controllerClass.getName()) + "." + methodName + "(): The argument of ActionKey can not be blank.");
                        }
                        if (!actionKey.startsWith(SLASH)) {
                            actionKey = SLASH + actionKey;
                        }
                        if (this.mapping.containsKey(actionKey)) {
                            ActionMapping.warnning(actionKey, controllerClass, method);
                        } else {
                            action = new Action(controllerKey, actionKey, controllerClass, method, methodName, actionInters, this.routes.getViewPath(controllerKey));
                            this.mapping.put(actionKey, action);
                        }
                    } else if (methodName.equals("index")) {
                        actionKey = controllerKey;
                        action = new Action(controllerKey, actionKey, controllerClass, method, methodName, actionInters, this.routes.getViewPath(controllerKey));
                        if ((action = this.mapping.put(actionKey, action)) != null) {
                            ActionMapping.warnning(action.getActionKey(), action.getControllerClass(), action.getMethod());
                        }
                    } else {
                        String string = actionKey = controllerKey.equals(SLASH) ? SLASH + methodName : String.valueOf(controllerKey) + SLASH + methodName;
                        if (this.mapping.containsKey(actionKey)) {
                            ActionMapping.warnning(actionKey, controllerClass, method);
                        } else {
                            action = new Action(controllerKey, actionKey, controllerClass, method, methodName, actionInters, this.routes.getViewPath(controllerKey));
                            this.mapping.put(actionKey, action);
                        }
                    }
                }
                ++n2;
            }
        }
        Action actoin = this.mapping.get(SLASH);
        if (actoin != null) {
            this.mapping.put("", actoin);
        }
    }

    private static final void warnning(String actionKey, Class<? extends Controller> controllerClass, Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append("--------------------------------------------------------------------------------\nWarnning!!!\n").append("ActionKey already used: \"").append(actionKey).append("\" \n").append("Action can not be mapped: \"").append(controllerClass.getName()).append(".").append(method.getName()).append("()\" \n").append("--------------------------------------------------------------------------------");
        System.out.println(sb.toString());
    }

    Action getAction(String url, String[] urlPara) {
        Action action = this.mapping.get(url);
        if (action != null) {
            return action;
        }
        int i = url.lastIndexOf(SLASH);
        if (i != -1) {
            action = this.mapping.get(url.substring(0, i));
            urlPara[0] = url.substring(i + 1);
        }
        return action;
    }

    List<String> getAllActionKeys() {
        ArrayList<String> allActionKeys = new ArrayList<String>(this.mapping.keySet());
        Collections.sort(allActionKeys);
        return allActionKeys;
    }
}

