/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Before;
import com.jfinal.aop.ClearInterceptor;
import com.jfinal.aop.ClearLayer;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.Controller;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class InterceptorBuilder {
    private static final Interceptor[] NULL_INTERCEPTOR_ARRAY = new Interceptor[0];
    private Map<Class<Interceptor>, Interceptor> intersMap = new HashMap<Class<Interceptor>, Interceptor>();

    InterceptorBuilder() {
    }

    void addToInterceptorsMap(Interceptor[] defaultInters) {
        Interceptor[] interceptorArray = defaultInters;
        int n = defaultInters.length;
        int n2 = 0;
        while (n2 < n) {
            Interceptor inter = interceptorArray[n2];
            this.intersMap.put(inter.getClass(), inter);
            ++n2;
        }
    }

    Interceptor[] buildControllerInterceptors(Class<? extends Controller> controllerClass) {
        Before before = controllerClass.getAnnotation(Before.class);
        return before != null ? this.createInterceptors(before) : NULL_INTERCEPTOR_ARRAY;
    }

    Interceptor[] buildMethodInterceptors(Method method) {
        Before before = method.getAnnotation(Before.class);
        return before != null ? this.createInterceptors(before) : NULL_INTERCEPTOR_ARRAY;
    }

    Interceptor[] buildActionInterceptors(Interceptor[] defaultInters, Interceptor[] controllerInters, Class<? extends Controller> controllerClass, Interceptor[] methodInters, Method method) {
        int size;
        ClearLayer methodClearType;
        ClearLayer controllerClearType = this.getControllerClearType(controllerClass);
        if (controllerClearType != null) {
            defaultInters = NULL_INTERCEPTOR_ARRAY;
        }
        if ((methodClearType = this.getMethodClearType(method)) != null) {
            controllerInters = NULL_INTERCEPTOR_ARRAY;
            if (methodClearType == ClearLayer.ALL) {
                defaultInters = NULL_INTERCEPTOR_ARRAY;
            }
        }
        Interceptor[] result = (size = defaultInters.length + controllerInters.length + methodInters.length) == 0 ? NULL_INTERCEPTOR_ARRAY : new Interceptor[size];
        int index = 0;
        int i = 0;
        while (i < defaultInters.length) {
            result[index++] = defaultInters[i];
            ++i;
        }
        i = 0;
        while (i < controllerInters.length) {
            result[index++] = controllerInters[i];
            ++i;
        }
        i = 0;
        while (i < methodInters.length) {
            result[index++] = methodInters[i];
            ++i;
        }
        return result;
    }

    private ClearLayer getMethodClearType(Method method) {
        ClearInterceptor clearInterceptor = method.getAnnotation(ClearInterceptor.class);
        return clearInterceptor != null ? clearInterceptor.value() : null;
    }

    private ClearLayer getControllerClearType(Class<? extends Controller> controllerClass) {
        ClearInterceptor clearInterceptor = controllerClass.getAnnotation(ClearInterceptor.class);
        return clearInterceptor != null ? clearInterceptor.value() : null;
    }

    private Interceptor[] createInterceptors(Before beforeAnnotation) {
        Interceptor[] result = null;
        Class<? extends Interceptor>[] interceptorClasses = beforeAnnotation.value();
        if (interceptorClasses != null && interceptorClasses.length > 0) {
            result = new Interceptor[interceptorClasses.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.intersMap.get(interceptorClasses[i]);
                if (result[i] == null) {
                    try {
                        result[i] = interceptorClasses[i].newInstance();
                        this.intersMap.put(interceptorClasses[i], result[i]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ++i;
            }
        }
        return result;
    }
}

