/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.ext.render;

import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import com.jfinal.render.Render;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;

public class CaptchaRender
extends Render {
    private static final int WIDTH = 85;
    private static final int HEIGHT = 20;
    private static final String[] strArr = new String[]{"3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "J", "K", "M", "N", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y"};
    private String randomCodeKey;

    public CaptchaRender(String randomCodeKey) {
        if (StrKit.isBlank(randomCodeKey)) {
            throw new IllegalArgumentException("randomCodeKey can not be blank");
        }
        this.randomCodeKey = randomCodeKey;
    }

    @Override
    public void render() {
        BufferedImage image = new BufferedImage(85, 20, 1);
        String vCode = this.drawGraphic(image);
        vCode = CaptchaRender.encrypt(vCode);
        Cookie cookie = new Cookie(this.randomCodeKey, vCode);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        this.response.addCookie(cookie);
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            try {
                sos = this.response.getOutputStream();
                ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)sos);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (sos != null) {
                try {
                    sos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String drawGraphic(BufferedImage image) {
        Graphics2D g = image.createGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, 85, 20);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(this.getRandColor(160, 200));
        int i = 0;
        while (i < 155) {
            int x = random.nextInt(85);
            int y = random.nextInt(20);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
            ++i;
        }
        String sRand = "";
        int i2 = 0;
        while (i2 < 4) {
            String rand = String.valueOf(strArr[random.nextInt(strArr.length)]);
            sRand = String.valueOf(sRand) + rand;
            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            ((Graphics)g).drawString(rand, 13 * i2 + 6, 16);
            ++i2;
        }
        g.dispose();
        return sRand;
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    private static final String encrypt(String srcStr) {
        try {
            byte[] bytes;
            String result = "";
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] byArray = bytes = md.digest(srcStr.getBytes("utf-8"));
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String hex = Integer.toHexString(b & 0xFF).toUpperCase();
                result = String.valueOf(result) + (hex.length() == 1 ? "0" : "") + hex;
                ++n2;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean validate(Controller controller, String inputRandomCode, String randomCodeKey) {
        if (StrKit.isBlank(inputRandomCode)) {
            return false;
        }
        try {
            inputRandomCode = CaptchaRender.encrypt(inputRandomCode);
            return inputRandomCode.equals(controller.getCookie(randomCodeKey));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

