/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class I18N {
    private static String baseName;
    private static Locale defaultLocale;
    private static int i18nMaxAgeOfCookie;
    private static final NullResourceBundle NULL_RESOURCE_BUNDLE;
    private static final ConcurrentMap<String, ResourceBundle> bundlesMap;
    private static volatile I18N me;

    static {
        defaultLocale = Locale.getDefault();
        i18nMaxAgeOfCookie = 999999999;
        NULL_RESOURCE_BUNDLE = new NullResourceBundle();
        bundlesMap = new ConcurrentHashMap<String, ResourceBundle>();
    }

    private I18N() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static I18N me() {
        if (me != null) return me;
        Class<I18N> clazz = I18N.class;
        synchronized (I18N.class) {
            if (me != null) return me;
            me = new I18N();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    public static void init(String baseName, Locale defaultLocale, Integer i18nMaxAgeOfCookie) {
        I18N.baseName = baseName;
        if (defaultLocale != null) {
            I18N.defaultLocale = defaultLocale;
        }
        if (i18nMaxAgeOfCookie != null) {
            I18N.i18nMaxAgeOfCookie = i18nMaxAgeOfCookie;
        }
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static final int getI18nMaxAgeOfCookie() {
        return i18nMaxAgeOfCookie;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        String resourceBundleKey = I18N.getresourceBundleKey(locale);
        ResourceBundle resourceBundle = (ResourceBundle)bundlesMap.get(resourceBundleKey);
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(baseName, locale);
                bundlesMap.put(resourceBundleKey, resourceBundle);
            }
            catch (MissingResourceException e) {
                resourceBundle = NULL_RESOURCE_BUNDLE;
            }
        }
        return resourceBundle;
    }

    private static String getresourceBundleKey(Locale locale) {
        return String.valueOf(baseName) + locale.toString();
    }

    public static String getText(String key) {
        return I18N.getResourceBundle(defaultLocale).getString(key);
    }

    public static String getText(String key, String defaultValue) {
        String result = I18N.getResourceBundle(defaultLocale).getString(key);
        return result != null ? result : defaultValue;
    }

    public static String getText(String key, Locale locale) {
        return I18N.getResourceBundle(locale).getString(key);
    }

    public static String getText(String key, String defaultValue, Locale locale) {
        String result = I18N.getResourceBundle(locale).getString(key);
        return result != null ? result : defaultValue;
    }

    public static Locale localeFromString(String localeStr) {
        if (localeStr == null || localeStr.trim().length() == 0 || "_".equals(localeStr)) {
            return defaultLocale;
        }
        int index = localeStr.indexOf(95);
        if (index < 0) {
            return new Locale(localeStr);
        }
        String language = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language);
        }
        if ((index = (localeStr = localeStr.substring(index + 1)).indexOf(95)) < 0) {
            return new Locale(language, localeStr);
        }
        String country = localeStr.substring(0, index);
        if (index == localeStr.length()) {
            return new Locale(language, country);
        }
        localeStr = localeStr.substring(index + 1);
        return new Locale(language, country, localeStr);
    }

    public static void main(String[] args) {
        System.out.println(Locale.CHINESE.getLanguage());
        System.out.println(Locale.CHINA.getLanguage());
        System.out.println(Locale.SIMPLIFIED_CHINESE.getLanguage());
        System.out.println(Locale.TRADITIONAL_CHINESE.getLanguage());
        System.out.println(Locale.TAIWAN.getLanguage());
        Locale shoudong = new Locale("en");
        System.out.println(shoudong.getLanguage().equals(Locale.US.getLanguage()));
        System.out.println(shoudong.getLanguage().equals(Locale.ENGLISH.getLanguage()));
        System.out.println(shoudong.getLanguage().equals(Locale.CANADA.getLanguage()));
        System.out.println(shoudong.getLanguage().equals(Locale.UK.getLanguage()));
        System.out.println(shoudong.getLanguage().equals(Locale.CANADA_FRENCH.getLanguage()));
    }

    private static class NullResourceBundle
    extends ResourceBundle {
        private NullResourceBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }
}

