/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.Model;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public final class DbKit {
    static Config config = null;
    static Config brokenConfig = new Config();
    private static Map<Class<? extends Model>, Config> modelToConfig = new HashMap<Class<? extends Model>, Config>();
    private static Map<String, Config> configNameToConfig = new HashMap<String, Config>();
    static final Object[] NULL_PARA_ARRAY = new Object[0];
    public static final String MAIN_CONFIG_NAME = "main";

    private DbKit() {
    }

    public static void addConfig(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        if (configNameToConfig.containsKey(config.getName())) {
            throw new IllegalArgumentException("Config already exists: " + config.getName());
        }
        configNameToConfig.put(config.getName(), config);
        if (MAIN_CONFIG_NAME.equals(config.getName())) {
            DbKit.config = config;
        }
        if (DbKit.config == null) {
            DbKit.config = config;
        }
    }

    static void addModelToConfigMapping(Class<? extends Model> modelClass, Config config) {
        modelToConfig.put(modelClass, config);
    }

    public static Config getConfig() {
        return config;
    }

    public static Config getConfig(String configName) {
        return configNameToConfig.get(configName);
    }

    public static Config getConfig(Class<? extends Model> modelClass) {
        return modelToConfig.get(modelClass);
    }

    static final void closeQuietly(ResultSet rs, Statement st) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static final void closeQuietly(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String replaceFormatSqlOrderBy(String sql) {
        int index = (sql = sql.replaceAll("(\\s)+", " ")).toLowerCase().lastIndexOf("order by");
        if (index > sql.toLowerCase().lastIndexOf(")")) {
            String sql1 = sql.substring(0, index);
            String sql2 = sql.substring(index);
            sql2 = sql2.replaceAll("[oO][rR][dD][eE][rR] [bB][yY] [\u4e00-\u9fa5a-zA-Z0-9_.]+((\\s)+(([dD][eE][sS][cC])|([aA][sS][cC])))?(( )*,( )*[\u4e00-\u9fa5a-zA-Z0-9_.]+(( )+(([dD][eE][sS][cC])|([aA][sS][cC])))?)*", "");
            return String.valueOf(sql1) + sql2;
        }
        return sql;
    }
}

