/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.dialect;

import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OracleDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from " + tableName + " where rownum < 1";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into ").append(table.getName()).append("(");
        StringBuilder temp = new StringBuilder(") values(");
        String pKey = table.getPrimaryKey();
        int count = 0;
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (count++ > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(colName);
            Object value = e.getValue();
            if (value instanceof String && colName.equalsIgnoreCase(pKey) && ((String)value).endsWith(".nextval")) {
                temp.append(value);
                continue;
            }
            temp.append("?");
            paras.add(value);
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public String forModelDeleteById(Table table) {
        String pKey = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from ");
        sql.append(table.getName());
        sql.append(" where ").append(pKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, String pKey, Object id, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(table.getName()).append(" set ");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (pKey.equalsIgnoreCase(colName) || !modifyFlag.contains(colName) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(pKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
                ++i;
            }
        }
        sql.append(" from ");
        sql.append(table.getName());
        sql.append(" where ").append(table.getPrimaryKey()).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbFindById(String tableName, String primaryKey, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
                ++i;
            }
        }
        sql.append(" from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String primaryKey) {
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(StringBuilder sql, List<Object> paras, String tableName, Record record) {
        sql.append("insert into ");
        sql.append(tableName.trim()).append("(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        int count = 0;
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (count++ > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(e.getKey());
            Object value = e.getValue();
            if (value instanceof String && ((String)value).endsWith(".nextval")) {
                temp.append(value);
                continue;
            }
            temp.append("?");
            paras.add(value);
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public void forDbUpdate(String tableName, String primaryKey, Object id, Record record, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(tableName.trim()).append(" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(primaryKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public void forPaginate(StringBuilder sql, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        int satrt = (pageNumber - 1) * pageSize + 1;
        int end = pageNumber * pageSize;
        sql.append("select * from ( select row_.*, rownum rownum_ from (  ");
        sql.append(select).append(" ").append(sqlExceptSelect);
        sql.append(" ) row_ where rownum <= ").append(end).append(") table_alias");
        sql.append(" where table_alias.rownum_ >= ").append(satrt);
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int i = 0;
        int size = paras.size();
        while (i < size) {
            Object value = paras.get(i);
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
            } else {
                pst.setObject(i + 1, value);
            }
            ++i;
        }
    }

    @Override
    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        int i = 0;
        while (i < paras.length) {
            Object value = paras[i];
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
            } else if (value instanceof Timestamp) {
                pst.setTimestamp(i + 1, (Timestamp)value);
            } else {
                pst.setObject(i + 1, value);
            }
            ++i;
        }
    }

    @Override
    public String getDefaultPrimaryKey() {
        return "ID";
    }
}

