/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.dialect;

import com.jfinal.plugin.activerecord.Record;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.dialect.Dialect;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PostgreSqlDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from \"" + tableName + "\" where 1 = 2";
    }

    @Override
    public void forModelSave(Table table, Map<String, Object> attrs, StringBuilder sql, List<Object> paras) {
        sql.append("insert into \"").append(table.getName()).append("\"(");
        StringBuilder temp = new StringBuilder(") values(");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (!table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append("\"").append(colName).append("\"");
            temp.append("?");
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public String forModelDeleteById(Table table) {
        String primaryKey = table.getPrimaryKey();
        StringBuilder sql = new StringBuilder(45);
        sql.append("delete from \"");
        sql.append(table.getName());
        sql.append("\" where \"").append(primaryKey).append("\" = ?");
        return sql.toString();
    }

    @Override
    public void forModelUpdate(Table table, Map<String, Object> attrs, Set<String> modifyFlag, String primaryKey, Object id, StringBuilder sql, List<Object> paras) {
        sql.append("update \"").append(table.getName()).append("\" set ");
        for (Map.Entry<String, Object> e : attrs.entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName) || !modifyFlag.contains(colName) || !table.hasColumnLabel(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append("\"").append(colName).append("\" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where \"").append(primaryKey).append("\" = ?");
        paras.add(id);
    }

    @Override
    public String forModelFindById(Table table, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append("\"").append(columnsArray[i].trim()).append("\"");
                ++i;
            }
        }
        sql.append(" from \"");
        sql.append(table.getName());
        sql.append("\" where \"").append(table.getPrimaryKey()).append("\" = ?");
        return sql.toString();
    }

    @Override
    public String forDbFindById(String tableName, String primaryKey, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            int i = 0;
            while (i < columnsArray.length) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append("\"").append(columnsArray[i].trim()).append("\"");
                ++i;
            }
        }
        sql.append(" from \"");
        sql.append(tableName.trim());
        sql.append("\" where \"").append(primaryKey).append("\" = ?");
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String primaryKey) {
        StringBuilder sql = new StringBuilder("delete from \"");
        sql.append(tableName.trim());
        sql.append("\" where \"").append(primaryKey).append("\" = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(StringBuilder sql, List<Object> paras, String tableName, Record record) {
        sql.append("insert into \"");
        sql.append(tableName.trim()).append("\"(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append("\"").append(e.getKey()).append("\"");
            temp.append("?");
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public void forDbUpdate(String tableName, String primaryKey, Object id, Record record, StringBuilder sql, List<Object> paras) {
        sql.append("update \"").append(tableName.trim()).append("\" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append("\"").append(colName).append("\" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where \"").append(primaryKey).append("\" = ?");
        paras.add(id);
    }

    @Override
    public void forPaginate(StringBuilder sql, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        int offset = pageSize * (pageNumber - 1);
        sql.append(select).append(" ");
        sql.append(sqlExceptSelect);
        sql.append(" limit ").append(pageSize).append(" offset ").append(offset);
    }
}

