/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.ActionInvocation;
import com.jfinal.core.Controller;
import com.jfinal.plugin.ehcache.CacheKit;
import com.jfinal.plugin.ehcache.CacheName;
import com.jfinal.plugin.ehcache.RenderInfo;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;

public class CacheInterceptor
implements Interceptor {
    private static final String renderKey = "$renderKey$";
    private static volatile ConcurrentHashMap<String, ReentrantLock> lockMap = new ConcurrentHashMap();

    private ReentrantLock getLock(String key) {
        ReentrantLock lock = lockMap.get(key);
        if (lock != null) {
            return lock;
        }
        lock = new ReentrantLock();
        ReentrantLock previousLock = lockMap.putIfAbsent(key, lock);
        return previousLock == null ? lock : previousLock;
    }

    @Override
    public final void intercept(ActionInvocation ai) {
        String cacheKey;
        Controller controller = ai.getController();
        String cacheName = this.buildCacheName(ai, controller);
        Map cacheData = (Map)CacheKit.get(cacheName, cacheKey = this.buildCacheKey(ai, controller));
        if (cacheData == null) {
            ReentrantLock lock = this.getLock(cacheName);
            lock.lock();
            try {
                cacheData = (Map)CacheKit.get(cacheName, cacheKey);
                if (cacheData == null) {
                    ai.invoke();
                    this.cacheAction(cacheName, cacheKey, controller);
                    return;
                }
            }
            finally {
                lock.unlock();
            }
        }
        this.useCacheDataAndRender(cacheData, controller);
    }

    private String buildCacheName(ActionInvocation ai, Controller controller) {
        CacheName cacheName = ai.getMethod().getAnnotation(CacheName.class);
        if (cacheName != null) {
            return cacheName.value();
        }
        cacheName = controller.getClass().getAnnotation(CacheName.class);
        return cacheName != null ? cacheName.value() : ai.getActionKey();
    }

    private String buildCacheKey(ActionInvocation ai, Controller controller) {
        String queryString;
        StringBuilder sb = new StringBuilder(ai.getActionKey());
        String urlPara = controller.getPara();
        if (urlPara != null) {
            sb.append("/").append(urlPara);
        }
        if ((queryString = controller.getRequest().getQueryString()) != null) {
            sb.append("?").append(queryString);
        }
        return sb.toString();
    }

    private void cacheAction(String cacheName, String cacheKey, Controller controller) {
        HttpServletRequest request = controller.getRequest();
        HashMap<String, Object> cacheData = new HashMap<String, Object>();
        Enumeration names = request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            cacheData.put(name, request.getAttribute(name));
        }
        cacheData.put(renderKey, new RenderInfo(controller.getRender()));
        CacheKit.put(cacheName, cacheKey, cacheData);
    }

    private void useCacheDataAndRender(Map<String, Object> cacheData, Controller controller) {
        HttpServletRequest request = controller.getRequest();
        Set<Map.Entry<String, Object>> set = cacheData.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            request.setAttribute(entry.getKey(), entry.getValue());
        }
        request.removeAttribute(renderKey);
        controller.render(((RenderInfo)cacheData.get(renderKey)).createRender());
    }
}

