/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.ehcache;

import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.JspRender;
import com.jfinal.render.Render;
import com.jfinal.render.VelocityRender;
import com.jfinal.render.XmlRender;
import java.io.Serializable;

public class RenderInfo
implements Serializable {
    private static final long serialVersionUID = -7299875545092102194L;
    private String view;
    private Integer renderType;

    public RenderInfo(Render render) {
        if (render == null) {
            throw new IllegalArgumentException("Render can not be null.");
        }
        this.view = render.getView();
        if (render instanceof FreeMarkerRender) {
            this.renderType = 1;
        } else if (render instanceof JspRender) {
            this.renderType = 2;
        } else if (render instanceof VelocityRender) {
            this.renderType = 3;
        } else if (render instanceof XmlRender) {
            this.renderType = 4;
        } else {
            throw new IllegalArgumentException("CacheInterceptor can not support the render of the type : " + render.getClass().getName());
        }
    }

    public Render createRender() {
        if (this.renderType == 1) {
            return new FreeMarkerRender(this.view);
        }
        if (this.renderType == 2) {
            return new JspRender(this.view);
        }
        if (this.renderType == 3) {
            return new VelocityRender(this.view);
        }
        if (this.renderType == 4) {
            return new XmlRender(this.view);
        }
        throw new IllegalArgumentException("CacheInterceptor can not support the renderType of the value : " + this.renderType);
    }
}

