/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.ModelRecordElResolver;
import com.jfinal.plugin.activerecord.Page;
import com.jfinal.plugin.activerecord.Record;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class JspRender
extends Render {
    private static boolean isSupportActiveRecord = false;
    private static int DEPTH;

    static {
        try {
            ModelRecordElResolver.init();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEPTH = 8;
    }

    @Deprecated
    public static void setSupportActiveRecord(boolean supportActiveRecord) {
        isSupportActiveRecord = supportActiveRecord;
        ModelRecordElResolver.setWorking(!isSupportActiveRecord);
    }

    public JspRender(String view) {
        this.view = view;
    }

    @Override
    public void render() {
        try {
            if (isSupportActiveRecord) {
                this.supportActiveRecord(this.request);
            }
            this.request.getRequestDispatcher(this.view).forward((ServletRequest)this.request, (ServletResponse)this.response);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
    }

    private void supportActiveRecord(HttpServletRequest request) {
        Enumeration attrs = request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String key = (String)attrs.nextElement();
            Object value = request.getAttribute(key);
            request.setAttribute(key, this.handleObject(value, DEPTH));
        }
    }

    private Object handleObject(Object value, int depth) {
        if (value == null || depth-- <= 0) {
            return value;
        }
        if (value instanceof List) {
            return this.handleList((List)value, depth);
        }
        if (value instanceof Model) {
            return this.handleMap(CPI.getAttrs((Model)value), depth);
        }
        if (value instanceof Record) {
            return this.handleMap(((Record)value).getColumns(), depth);
        }
        if (value instanceof Map) {
            return this.handleMap((Map)value, depth);
        }
        if (value instanceof Page) {
            return this.handlePage((Page)value, depth);
        }
        if (value instanceof Object[]) {
            return this.handleArray((Object[])value, depth);
        }
        return value;
    }

    private Map handleMap(Map map, int depth) {
        if (map == null || map.size() == 0) {
            return map;
        }
        Map result = map;
        for (Map.Entry e : result.entrySet()) {
            Object key = e.getKey();
            Object value = e.getValue();
            value = this.handleObject(value, depth);
            result.put(key, value);
        }
        return result;
    }

    private List handleList(List list, int depth) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object value : list) {
            result.add(this.handleObject(value, depth));
        }
        return result;
    }

    private Object handlePage(Page page, int depth) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("list", this.handleList(page.getList(), depth));
        result.put("pageNumber", page.getPageNumber());
        result.put("pageSize", page.getPageSize());
        result.put("totalPage", page.getTotalPage());
        result.put("totalRow", page.getTotalRow());
        return result;
    }

    private List handleArray(Object[] array, int depth) {
        if (array == null || array.length == 0) {
            return new ArrayList(0);
        }
        ArrayList<Object> result = new ArrayList<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            result.add(this.handleObject(array[i], depth));
            ++i;
        }
        return result;
    }
}

