/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.config.Constants;
import com.jfinal.core.Const;
import com.jfinal.kit.PathKit;
import com.jfinal.plugin.activerecord.ModelRecordElResolver;
import com.jfinal.render.ContentType;
import com.jfinal.render.ErrorRender;
import com.jfinal.render.FileRender;
import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.HtmlRender;
import com.jfinal.render.IErrorRenderFactory;
import com.jfinal.render.IMainRenderFactory;
import com.jfinal.render.JavascriptRender;
import com.jfinal.render.JsonRender;
import com.jfinal.render.JspRender;
import com.jfinal.render.NullRender;
import com.jfinal.render.Redirect301Render;
import com.jfinal.render.RedirectRender;
import com.jfinal.render.Render;
import com.jfinal.render.TextRender;
import com.jfinal.render.VelocityRender;
import com.jfinal.render.ViewType;
import com.jfinal.render.XmlRender;
import java.io.File;
import java.util.Locale;
import javax.servlet.ServletContext;

public class RenderFactory {
    private Constants constants;
    private static IMainRenderFactory mainRenderFactory;
    private static IErrorRenderFactory errorRenderFactory;
    private static ServletContext servletContext;
    private static final RenderFactory me;

    static {
        me = new RenderFactory();
    }

    static ServletContext getServletContext() {
        return servletContext;
    }

    private RenderFactory() {
    }

    public static RenderFactory me() {
        return me;
    }

    public static void setMainRenderFactory(IMainRenderFactory mainRenderFactory) {
        if (mainRenderFactory != null) {
            RenderFactory.mainRenderFactory = mainRenderFactory;
        }
    }

    public static void setErrorRenderFactory(IErrorRenderFactory errorRenderFactory) {
        if (errorRenderFactory != null) {
            RenderFactory.errorRenderFactory = errorRenderFactory;
        }
    }

    public void init(Constants constants, ServletContext servletContext) {
        this.constants = constants;
        RenderFactory.servletContext = servletContext;
        Render.init(constants.getEncoding(), constants.getDevMode());
        this.initFreeMarkerRender(servletContext);
        this.initVelocityRender(servletContext);
        this.initJspRender(servletContext);
        this.initFileRender(servletContext);
        if (mainRenderFactory == null) {
            ViewType defaultViewType = constants.getViewType();
            if (defaultViewType == ViewType.FREE_MARKER) {
                mainRenderFactory = new FreeMarkerRenderFactory();
            } else if (defaultViewType == ViewType.JSP) {
                mainRenderFactory = new JspRenderFactory();
            } else if (defaultViewType == ViewType.VELOCITY) {
                mainRenderFactory = new VelocityRenderFactory();
            } else {
                throw new RuntimeException("View Type can not be null.");
            }
        }
        if (errorRenderFactory == null) {
            errorRenderFactory = new ErrorRenderFactory();
        }
    }

    private void initFreeMarkerRender(ServletContext servletContext) {
        try {
            Class.forName("freemarker.template.Template");
            FreeMarkerRender.init(servletContext, Locale.getDefault(), this.constants.getFreeMarkerTemplateUpdateDelay());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void initVelocityRender(ServletContext servletContext) {
        try {
            Class.forName("org.apache.velocity.VelocityContext");
            VelocityRender.init(servletContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void initJspRender(ServletContext servletContext) {
        try {
            Class.forName("javax.el.ELResolver");
            Class.forName("javax.servlet.jsp.JspFactory");
            ModelRecordElResolver.init(servletContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initFileRender(ServletContext servletContext) {
        FileRender.init(this.getFileRenderPath(), servletContext);
    }

    private String getFileRenderPath() {
        String result = this.constants.getFileRenderPath();
        if (result == null) {
            result = String.valueOf(PathKit.getWebRootPath()) + Const.DEFAULT_FILE_RENDER_BASE_PATH;
        }
        if (!result.endsWith(File.separator) && !result.endsWith("/")) {
            result = String.valueOf(result) + File.separator;
        }
        return result;
    }

    public Render getRender(String view) {
        return mainRenderFactory.getRender(view);
    }

    public Render getFreeMarkerRender(String view) {
        return new FreeMarkerRender(view);
    }

    public Render getJspRender(String view) {
        return new JspRender(view);
    }

    public Render getVelocityRender(String view) {
        return new VelocityRender(view);
    }

    public Render getJsonRender() {
        return new JsonRender();
    }

    public Render getJsonRender(String key, Object value) {
        return new JsonRender(key, value);
    }

    public Render getJsonRender(String[] attrs) {
        return new JsonRender(attrs);
    }

    public Render getJsonRender(String jsonText) {
        return new JsonRender(jsonText);
    }

    public Render getJsonRender(Object object) {
        return new JsonRender(object);
    }

    public Render getTextRender(String text) {
        return new TextRender(text);
    }

    public Render getTextRender(String text, String contentType) {
        return new TextRender(text, contentType);
    }

    public Render getTextRender(String text, ContentType contentType) {
        return new TextRender(text, contentType);
    }

    public Render getDefaultRender(String view) {
        ViewType viewType = this.constants.getViewType();
        if (viewType == ViewType.FREE_MARKER) {
            return new FreeMarkerRender(String.valueOf(view) + this.constants.getFreeMarkerViewExtension());
        }
        if (viewType == ViewType.JSP) {
            return new JspRender(String.valueOf(view) + this.constants.getJspViewExtension());
        }
        if (viewType == ViewType.VELOCITY) {
            return new VelocityRender(String.valueOf(view) + this.constants.getVelocityViewExtension());
        }
        return mainRenderFactory.getRender(String.valueOf(view) + mainRenderFactory.getViewExtension());
    }

    public Render getErrorRender(int errorCode, String view) {
        return errorRenderFactory.getRender(errorCode, view);
    }

    public Render getErrorRender(int errorCode) {
        return errorRenderFactory.getRender(errorCode, this.constants.getErrorView(errorCode));
    }

    public Render getFileRender(String fileName) {
        return new FileRender(fileName);
    }

    public Render getFileRender(File file) {
        return new FileRender(file);
    }

    public Render getRedirectRender(String url) {
        return new RedirectRender(url);
    }

    public Render getRedirectRender(String url, boolean withQueryString) {
        return new RedirectRender(url, withQueryString);
    }

    public Render getRedirect301Render(String url) {
        return new Redirect301Render(url);
    }

    public Render getRedirect301Render(String url, boolean withQueryString) {
        return new Redirect301Render(url, withQueryString);
    }

    public Render getNullRender() {
        return new NullRender();
    }

    public Render getJavascriptRender(String jsText) {
        return new JavascriptRender(jsText);
    }

    public Render getHtmlRender(String htmlText) {
        return new HtmlRender(htmlText);
    }

    public Render getXmlRender(String view) {
        return new XmlRender(view);
    }

    private static final class ErrorRenderFactory
    implements IErrorRenderFactory {
        private ErrorRenderFactory() {
        }

        @Override
        public Render getRender(int errorCode, String view) {
            return new ErrorRender(errorCode, view);
        }
    }

    private static final class FreeMarkerRenderFactory
    implements IMainRenderFactory {
        private FreeMarkerRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new FreeMarkerRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".html";
        }
    }

    private static final class JspRenderFactory
    implements IMainRenderFactory {
        private JspRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new JspRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".jsp";
        }
    }

    private static final class VelocityRenderFactory
    implements IMainRenderFactory {
        private VelocityRenderFactory() {
        }

        @Override
        public Render getRender(String view) {
            return new VelocityRender(view);
        }

        @Override
        public String getViewExtension() {
            return ".html";
        }
    }
}

