/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.ContentType;
import com.jfinal.render.Render;
import com.jfinal.render.RenderException;
import java.io.IOException;
import java.io.PrintWriter;

public class TextRender
extends Render {
    private static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=" + TextRender.getEncoding();
    private String text;
    private String contentType;

    public TextRender(String text) {
        this.text = text;
    }

    public TextRender(String text, String contentType) {
        this.text = text;
        this.contentType = contentType;
    }

    public TextRender(String text, ContentType contentType) {
        this.text = text;
        this.contentType = contentType.value();
    }

    @Override
    public void render() {
        PrintWriter writer = null;
        try {
            try {
                this.response.setHeader("Pragma", "no-cache");
                this.response.setHeader("Cache-Control", "no-cache");
                this.response.setDateHeader("Expires", 0L);
                if (this.contentType == null) {
                    this.response.setContentType(DEFAULT_CONTENT_TYPE);
                } else {
                    this.response.setContentType(this.contentType);
                    this.response.setCharacterEncoding(TextRender.getEncoding());
                }
                writer = this.response.getWriter();
                writer.write(this.text);
                writer.flush();
            }
            catch (IOException e) {
                throw new RenderException(e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

