/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.render;

import com.jfinal.render.FreeMarkerRender;
import com.jfinal.render.RenderException;
import freemarker.template.Template;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;

public class XmlRender
extends FreeMarkerRender {
    private static final String contentType = "text/xml; charset=" + XmlRender.getEncoding();

    public XmlRender(String view) {
        super(view);
    }

    @Override
    public void render() {
        this.response.setContentType(contentType);
        HashMap<String, Object> root = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            root.put(attrName, this.request.getAttribute(attrName));
        }
        PrintWriter writer = null;
        try {
            try {
                Template template = XmlRender.getConfiguration().getTemplate(this.view);
                writer = this.response.getWriter();
                template.process(root, (Writer)writer);
            }
            catch (Exception e) {
                throw new RenderException(e);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

