/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server;

import com.jfinal.kit.PathKit;
import com.jfinal.server.IServer;
import com.jfinal.server.JettyServer;
import java.io.File;

public class ServerFactory {
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_SCANINTERVALSECONDS = 5;

    private ServerFactory() {
    }

    public static IServer getServer(String webAppDir, int port, String context, int scanIntervalSeconds) {
        return new JettyServer(webAppDir, port, context, scanIntervalSeconds);
    }

    public static IServer getServer(String webAppDir, int port, String context) {
        return ServerFactory.getServer(webAppDir, port, context, 5);
    }

    public static IServer getServer(int port, String context, int scanIntervalSeconds) {
        return ServerFactory.getServer(ServerFactory.detectWebAppDir(), port, context, scanIntervalSeconds);
    }

    public static IServer getServer(int port, String context) {
        return ServerFactory.getServer(ServerFactory.detectWebAppDir(), port, context, 5);
    }

    public static IServer getServer(int port) {
        return ServerFactory.getServer(ServerFactory.detectWebAppDir(), port, "/", 5);
    }

    public static IServer getServer() {
        return ServerFactory.getServer(ServerFactory.detectWebAppDir(), 80, "/", 5);
    }

    private static String detectWebAppDir() {
        String rootClassPath = PathKit.getRootClassPath();
        String[] temp = null;
        if (rootClassPath.indexOf("\\WEB-INF\\") != -1) {
            temp = rootClassPath.split("\\\\");
        } else if (rootClassPath.indexOf("/WEB-INF/") != -1) {
            temp = rootClassPath.split("/");
        } else {
            throw new RuntimeException("WEB-INF directory not found.");
        }
        return temp[temp.length - 3];
    }

    @Deprecated
    private static String detectWebAppDir_old() {
        String rootClassPath = PathKit.getRootClassPath();
        String[] temp = null;
        try {
            temp = rootClassPath.split(File.separator);
        }
        catch (Exception e) {
            temp = rootClassPath.split("\\\\");
        }
        return temp[temp.length - 3];
    }
}

