/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.upload;

import com.jfinal.upload.UploadFile;
import com.oreilly.servlet.multipart.DefaultFileRenamePolicy;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultipartRequest
extends HttpServletRequestWrapper {
    private static String saveDirectory;
    private static int maxPostSize;
    private static String encoding;
    private static boolean isMultipartSupported;
    private static final DefaultFileRenamePolicy fileRenamePolicy;
    private List<UploadFile> uploadFiles;
    private com.oreilly.servlet.MultipartRequest multipartRequest;

    static {
        isMultipartSupported = false;
        fileRenamePolicy = new DefaultFileRenamePolicy();
    }

    static void init(String saveDirectory, int maxPostSize, String encoding) {
        MultipartRequest.saveDirectory = saveDirectory;
        MultipartRequest.maxPostSize = maxPostSize;
        MultipartRequest.encoding = encoding;
        isMultipartSupported = true;
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) {
        super(request);
        this.wrapMultipartRequest(request, saveDirectory, maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) {
        super(request);
        this.wrapMultipartRequest(request, saveDirectory, maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory) {
        super(request);
        this.wrapMultipartRequest(request, saveDirectory, maxPostSize, encoding);
    }

    public MultipartRequest(HttpServletRequest request) {
        super(request);
        this.wrapMultipartRequest(request, saveDirectory, maxPostSize, encoding);
    }

    private String handleSaveDirectory(String saveDirectory) {
        if (saveDirectory.startsWith("/") || saveDirectory.indexOf(":") == 1) {
            return saveDirectory;
        }
        return String.valueOf(MultipartRequest.saveDirectory) + saveDirectory;
    }

    private void wrapMultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) {
        if (!isMultipartSupported) {
            throw new RuntimeException("Oreilly cos.jar is not found, Multipart post can not be supported.");
        }
        File dir = new File(saveDirectory = this.handleSaveDirectory(saveDirectory));
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Directory " + saveDirectory + " not exists and can not create directory.");
        }
        this.uploadFiles = new ArrayList<UploadFile>();
        try {
            this.multipartRequest = new com.oreilly.servlet.MultipartRequest(request, saveDirectory, maxPostSize, encoding, (FileRenamePolicy)fileRenamePolicy);
            Enumeration files = this.multipartRequest.getFileNames();
            while (files.hasMoreElements()) {
                String contentType;
                String originalFileName;
                UploadFile uploadFile;
                String name = (String)files.nextElement();
                String filesystemName = this.multipartRequest.getFilesystemName(name);
                if (filesystemName == null || !this.isSafeFile(uploadFile = new UploadFile(name, saveDirectory, filesystemName, originalFileName = this.multipartRequest.getOriginalFileName(name), contentType = this.multipartRequest.getContentType(name)))) continue;
                this.uploadFiles.add(uploadFile);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSafeFile(UploadFile uploadFile) {
        if (uploadFile.getFileName().toLowerCase().endsWith(".jsp")) {
            uploadFile.getFile().delete();
            return false;
        }
        return true;
    }

    public List<UploadFile> getFiles() {
        return this.uploadFiles;
    }

    public Enumeration getParameterNames() {
        return this.multipartRequest.getParameterNames();
    }

    public String getParameter(String name) {
        return this.multipartRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.multipartRequest.getParameterValues(name);
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Enumeration enumm = this.getParameterNames();
        while (enumm.hasMoreElements()) {
            String name = (String)enumm.nextElement();
            map.put(name, this.multipartRequest.getParameterValues(name));
        }
        return map;
    }
}

