/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.UserType;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class BaseUserAuthentication
implements UserAuthentication {
    private static final a LOGGER = b.ad();
    protected static final String STORAGE_KEY_PROFILE_NAME = "displayName";
    protected static final String STORAGE_KEY_PROFILE_ID = "uuid";
    protected static final String STORAGE_KEY_PROFILE_PROPERTIES = "profileProperties";
    protected static final String STORAGE_KEY_USER_NAME = "username";
    protected static final String STORAGE_KEY_USER_ID = "userid";
    protected static final String STORAGE_KEY_USER_PROPERTIES = "userProperties";
    private final AuthenticationService authenticationService;
    private final PropertyMap userProperties = new PropertyMap();
    private String userid;
    private String username;
    private String password;
    private GameProfile selectedProfile;
    private UserType userType;

    protected BaseUserAuthentication(AuthenticationService authenticationService) {
        Validate.notNull(authenticationService);
        this.authenticationService = authenticationService;
    }

    @Override
    public boolean canLogIn() {
        return !this.canPlayOnline() && StringUtils.isNotBlank(this.getUsername()) && StringUtils.isNotBlank(this.getPassword());
    }

    @Override
    public void logOut() {
        this.password = null;
        this.userid = null;
        this.setSelectedProfile(null);
        this.getModifiableUserProperties().clear();
        this.setUserType(null);
    }

    @Override
    public boolean isLoggedIn() {
        return this.getSelectedProfile() != null;
    }

    @Override
    public void setUsername(String string) {
        if (this.isLoggedIn() && this.canPlayOnline()) {
            throw new IllegalStateException("Cannot change username whilst logged in & online");
        }
        this.username = string;
    }

    @Override
    public void setPassword(String string) {
        if (this.isLoggedIn() && this.canPlayOnline() && StringUtils.isNotBlank(string)) {
            throw new IllegalStateException("Cannot set password whilst logged in & online");
        }
        this.password = string;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public void loadFromStorage(Map<String, Object> object) {
        String string;
        this.logOut();
        this.setUsername(String.valueOf(object.get(STORAGE_KEY_USER_NAME)));
        this.userid = object.containsKey(STORAGE_KEY_USER_ID) ? String.valueOf(object.get(STORAGE_KEY_USER_ID)) : this.username;
        if (object.containsKey(STORAGE_KEY_USER_PROPERTIES)) {
            try {
                for (Object object2 : (List)object.get(STORAGE_KEY_USER_PROPERTIES)) {
                    String string2 = (String)object2.get("name");
                    string = (String)object2.get("value");
                    if ((object2 = (String)object2.get("signature")) == null) {
                        this.getModifiableUserProperties().put(string2, new Property(string2, string));
                        continue;
                    }
                    this.getModifiableUserProperties().put(string2, new Property(string2, string, (String)object2));
                }
            }
            catch (Throwable throwable) {
                LOGGER.log(Level.WARNING, "Couldn't deserialize user properties", throwable);
            }
        }
        if (object.containsKey(STORAGE_KEY_PROFILE_NAME) && object.containsKey(STORAGE_KEY_PROFILE_ID)) {
            GameProfile gameProfile = new GameProfile(UUIDTypeAdapter.fromString(String.valueOf(object.get(STORAGE_KEY_PROFILE_ID))), String.valueOf(object.get(STORAGE_KEY_PROFILE_NAME)));
            if (object.containsKey(STORAGE_KEY_PROFILE_PROPERTIES)) {
                try {
                    for (Object object3 : (List)object.get(STORAGE_KEY_PROFILE_PROPERTIES)) {
                        Object object2;
                        string = (String)object3.get("name");
                        object2 = (String)object3.get("value");
                        object = (String)object3.get("signature");
                        if (object == null) {
                            gameProfile.getProperties().put(string, new Property(string, (String)object2));
                            continue;
                        }
                        gameProfile.getProperties().put(string, new Property(string, (String)object2, (String)object));
                    }
                }
                catch (Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Couldn't deserialize profile properties", throwable);
                }
            }
            this.setSelectedProfile(gameProfile);
        }
    }

    @Override
    public Map<String, Object> saveForStorage() {
        HashMap<String, String> hashMap;
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        if (this.getUsername() != null) {
            hashMap2.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (this.getUserID() != null) {
            hashMap2.put(STORAGE_KEY_USER_ID, this.getUserID());
        } else if (this.getUsername() != null) {
            hashMap2.put(STORAGE_KEY_USER_NAME, this.getUsername());
        }
        if (!this.getUserProperties().isEmpty()) {
            hashMap = new ArrayList();
            for (Object object : this.getUserProperties().values()) {
                HashMap<String, String> hashMap3 = new HashMap<String, String>();
                hashMap3.put("name", ((Property)object).getName());
                hashMap3.put("value", ((Property)object).getValue());
                hashMap3.put("signature", ((Property)object).getSignature());
                hashMap.add(hashMap3);
            }
            hashMap2.put(STORAGE_KEY_USER_PROPERTIES, hashMap);
        }
        if ((hashMap = this.getSelectedProfile()) != null) {
            Object object;
            hashMap2.put(STORAGE_KEY_PROFILE_NAME, ((GameProfile)((Object)hashMap)).getName());
            hashMap2.put(STORAGE_KEY_PROFILE_ID, ((GameProfile)((Object)hashMap)).getId());
            object = new ArrayList();
            for (Object object2 : ((GameProfile)((Object)hashMap)).getProperties().values()) {
                hashMap = new HashMap<String, String>();
                hashMap.put("name", ((Property)object2).getName());
                hashMap.put("value", ((Property)object2).getValue());
                hashMap.put("signature", ((Property)object2).getSignature());
                object.add(hashMap);
            }
            if (!object.isEmpty()) {
                hashMap2.put(STORAGE_KEY_PROFILE_PROPERTIES, object);
            }
        }
        return hashMap2;
    }

    public void setSelectedProfile(GameProfile gameProfile) {
        this.selectedProfile = gameProfile;
    }

    @Override
    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append("{");
        if (this.isLoggedIn()) {
            stringBuilder.append("Logged in as ");
            stringBuilder.append(this.getUsername());
            if (this.getSelectedProfile() != null) {
                stringBuilder.append(" / ");
                stringBuilder.append(this.getSelectedProfile());
                stringBuilder.append(" - ");
                stringBuilder.append(this.canPlayOnline() ? "Online" : "Offline");
            }
        } else {
            stringBuilder.append("Not logged in");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    @Override
    public String getUserID() {
        return this.userid;
    }

    @Override
    public PropertyMap getUserProperties() {
        if (this.isLoggedIn()) {
            PropertyMap propertyMap = new PropertyMap();
            propertyMap.putAll(this.getModifiableUserProperties());
            return propertyMap;
        }
        return new PropertyMap();
    }

    public PropertyMap getModifiableUserProperties() {
        return this.userProperties;
    }

    @Override
    public UserType getUserType() {
        if (this.isLoggedIn()) {
            if (this.userType == null) {
                return UserType.LEGACY;
            }
            return this.userType;
        }
        return null;
    }

    public void setUserType(UserType userType) {
        this.userType = userType;
    }

    public void setUserid(String string) {
        this.userid = string;
    }
}

