/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib;

import com.mojang.authlib.BaseAuthenticationService;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public abstract class HttpAuthenticationService
extends BaseAuthenticationService {
    private static final a LOGGER = b.ad();
    private final Proxy proxy;

    public HttpAuthenticationService(Proxy proxy) {
        Validate.notNull(proxy);
        this.proxy = proxy;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    protected HttpURLConnection createUrlConnection(URL object) throws IOException {
        Validate.notNull(object);
        LOGGER.a("Opening connection to %s", object);
        object = (HttpURLConnection)((URL)object).openConnection(this.proxy);
        ((URLConnection)object).setConnectTimeout(15000);
        ((URLConnection)object).setReadTimeout(15000);
        ((URLConnection)object).setUseCaches(false);
        return object;
    }

    public String performPostRequest(URL object, String object2, String object3) throws IOException {
        Validate.notNull(object);
        Validate.notNull(object2);
        Validate.notNull(object3);
        HttpURLConnection httpURLConnection = this.createUrlConnection((URL)object);
        byte[] byArray = ((String)object2).getBytes(Charsets.UTF_8);
        httpURLConnection.setRequestProperty("Content-Type", String.valueOf(object3) + "; charset=utf-8");
        httpURLConnection.setRequestProperty("Content-Length", "" + byArray.length);
        httpURLConnection.setDoOutput(true);
        LOGGER.a("Writing POST data to %s: %s", object, object2);
        object2 = null;
        try {
            object2 = httpURLConnection.getOutputStream();
            IOUtils.write(byArray, (OutputStream)object2);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)object2);
        }
        LOGGER.a("Reading data from %s", object);
        object3 = null;
        try {
            object3 = httpURLConnection.getInputStream();
            object2 = IOUtils.toString((InputStream)object3, Charsets.UTF_8);
            LOGGER.a("Successful read, server response was %s", httpURLConnection.getResponseCode());
            LOGGER.a("Response: %s", object2);
            return object2;
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((InputStream)object3);
            object3 = httpURLConnection.getErrorStream();
            if (object3 != null) {
                LOGGER.a("Reading error page from %s", object);
                object = IOUtils.toString((InputStream)object3, Charsets.UTF_8);
                LOGGER.a("Successful read, server response was %s", httpURLConnection.getResponseCode());
                LOGGER.a("Response: %s", object);
                Object object4 = object;
                return object4;
            }
            LOGGER.log(Level.INFO, "Request failed", iOException);
            throw iOException;
        }
        finally {
            IOUtils.closeQuietly((InputStream)object3);
        }
    }

    public String performGetRequest(URL object) throws IOException {
        Validate.notNull(object);
        HttpURLConnection httpURLConnection = this.createUrlConnection((URL)object);
        LOGGER.a("Reading data from %s", object);
        InputStream inputStream = null;
        try {
            inputStream = httpURLConnection.getInputStream();
            String string = IOUtils.toString(inputStream, Charsets.UTF_8);
            LOGGER.a("Successful read, server response was %s", httpURLConnection.getResponseCode());
            LOGGER.a("Response: %s", string);
            return string;
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(inputStream);
            inputStream = httpURLConnection.getErrorStream();
            if (inputStream != null) {
                LOGGER.a("Reading error page from %s", object);
                object = IOUtils.toString(inputStream, Charsets.UTF_8);
                LOGGER.a("Successful read, server response was %s", httpURLConnection.getResponseCode());
                LOGGER.a("Response: %s", object);
                Object object2 = object;
                return object2;
            }
            LOGGER.log(Level.INFO, "Request failed", iOException);
            throw iOException;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static URL constantURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("Couldn't create constant for " + string, malformedURLException);
        }
    }

    public static String buildQuery(Map<String, Object> object2) {
        if (object2 == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : object2.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('&');
            }
            try {
                stringBuilder.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.SEVERE, "Unexpected exception building query", unsupportedEncodingException);
            }
            if (entry.getValue() == null) continue;
            stringBuilder.append('=');
            try {
                stringBuilder.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.SEVERE, "Unexpected exception building query", unsupportedEncodingException);
            }
        }
        return stringBuilder.toString();
    }

    public static URL concatenateURL(URL uRL, String string) {
        try {
            if (uRL.getQuery() != null && uRL.getQuery().length() > 0) {
                return new URL(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getFile()) + "&" + string);
            }
            return new URL(uRL.getProtocol(), uRL.getHost(), String.valueOf(uRL.getFile()) + "?" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Could not concatenate given URL with GET arguments!", malformedURLException);
        }
    }
}

