/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.legacy;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.legacy.LegacyAuthenticationService;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class LegacyMinecraftSessionService
extends HttpMinecraftSessionService {
    private static final String BASE_URL = "http://session.minecraft.net/game/";
    private static final URL JOIN_URL = HttpAuthenticationService.constantURL("http://session.minecraft.net/game/joinserver.jsp");
    private static final URL CHECK_URL = HttpAuthenticationService.constantURL("http://session.minecraft.net/game/checkserver.jsp");

    protected LegacyMinecraftSessionService(LegacyAuthenticationService legacyAuthenticationService) {
        super(legacyAuthenticationService);
    }

    @Override
    public void joinServer(GameProfile object, String string, String string2) throws AuthenticationException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("user", ((GameProfile)object).getName());
        hashMap.put("sessionId", string);
        hashMap.put("serverId", string2);
        object = HttpAuthenticationService.concatenateURL(JOIN_URL, HttpAuthenticationService.buildQuery(hashMap));
        try {
            object = this.getAuthenticationService().performGetRequest((URL)object);
            if (!((String)object).equals("OK")) {
                throw new AuthenticationException((String)object);
            }
        }
        catch (IOException iOException) {
            throw new AuthenticationUnavailableException(iOException);
        }
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String object) throws AuthenticationUnavailableException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("user", gameProfile.getName());
        hashMap.put("serverId", object);
        object = HttpAuthenticationService.concatenateURL(CHECK_URL, HttpAuthenticationService.buildQuery(hashMap));
        try {
            if (this.getAuthenticationService().performGetRequest((URL)object).equals("YES")) {
                return gameProfile;
            }
            return null;
        }
        catch (IOException iOException) {
            throw new AuthenticationUnavailableException(iOException);
        }
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile gameProfile, boolean bl) {
        return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile) {
        return gameProfile;
    }

    @Override
    public LegacyAuthenticationService getAuthenticationService() {
        return (LegacyAuthenticationService)super.getAuthenticationService();
    }
}

