/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.UserAuthentication;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilGameProfileRepository;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class YggdrasilAuthenticationService
extends HttpAuthenticationService {
    private final String clientToken;
    private final Gson gson;

    public YggdrasilAuthenticationService(Proxy object, String string) {
        super((Proxy)object);
        this.clientToken = string;
        object = new GsonBuilder();
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)GameProfile.class), new GameProfileSerializer());
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)PropertyMap.class), new PropertyMap.Serializer());
        ((GsonBuilder)object).registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter());
        this.gson = ((GsonBuilder)object).create();
    }

    @Override
    public UserAuthentication createUserAuthentication(Agent agent) {
        return new YggdrasilUserAuthentication(this, agent);
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new YggdrasilMinecraftSessionService(this);
    }

    @Override
    public GameProfileRepository createProfileRepository() {
        return new YggdrasilGameProfileRepository(this);
    }

    protected <T extends Response> T makeRequest(URL object, Object object2, Class<T> clazz) throws AuthenticationException {
        block8: {
            object = object2 == null ? this.performGetRequest((URL)object) : this.performPostRequest((URL)object, this.gson.toJson(object2), "application/json");
            object = (Response)this.gson.fromJson((String)object, clazz);
            if (object != null) break block8;
            return null;
        }
        try {
            if (StringUtils.isNotBlank(((Response)object).getError())) {
                if ("UserMigratedException".equals(((Response)object).getCause())) {
                    throw new UserMigratedException(((Response)object).getErrorMessage());
                }
                if (((Response)object).getError().equals("ForbiddenOperationException")) {
                    throw new InvalidCredentialsException(((Response)object).getErrorMessage());
                }
                throw new AuthenticationException(((Response)object).getErrorMessage());
            }
            return (T)object;
        }
        catch (IOException iOException) {
            throw new AuthenticationUnavailableException("Cannot contact authentication server", iOException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new AuthenticationUnavailableException("Cannot contact authentication server", illegalStateException);
        }
        catch (JsonParseException jsonParseException) {
            throw new AuthenticationUnavailableException("Cannot contact authentication server", jsonParseException);
        }
    }

    public String getClientToken() {
        return this.clientToken;
    }

    static class GameProfileSerializer
    implements JsonDeserializer<GameProfile>,
    JsonSerializer<GameProfile> {
        private GameProfileSerializer() {
        }

        @Override
        public GameProfile deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            type = ((JsonObject)(jsonElement = (JsonObject)jsonElement)).has("id") ? (UUID)jsonDeserializationContext.deserialize(((JsonObject)jsonElement).get("id"), (Type)((Object)UUID.class)) : null;
            jsonElement = ((JsonObject)jsonElement).has("name") ? ((JsonObject)jsonElement).getAsJsonPrimitive("name").getAsString() : null;
            return new GameProfile((UUID)((Object)type), (String)((Object)jsonElement));
        }

        @Override
        public JsonElement serialize(GameProfile gameProfile, Type object, JsonSerializationContext jsonSerializationContext) {
            object = new JsonObject();
            if (gameProfile.getId() != null) {
                ((JsonObject)object).add("id", jsonSerializationContext.serialize(gameProfile.getId()));
            }
            if (gameProfile.getName() != null) {
                ((JsonObject)object).addProperty("name", gameProfile.getName());
            }
            return object;
        }
    }
}

