/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import com.teamextreme.fyre.d;
import java.util.HashSet;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class YggdrasilGameProfileRepository
implements GameProfileRepository {
    private static final a LOGGER = b.ad();
    private static final String BASE_URL = "https://api.mojang.com/";
    private static final String SEARCH_PAGE_URL = "https://api.mojang.com/profiles/page/";
    private static final int MAX_FAIL_COUNT = 3;
    private static final int DELAY_BETWEEN_PAGES = 100;
    private static final int DELAY_BETWEEN_FAILURES = 750;
    private final YggdrasilAuthenticationService authenticationService;

    public YggdrasilGameProfileRepository(YggdrasilAuthenticationService yggdrasilAuthenticationService) {
        this.authenticationService = yggdrasilAuthenticationService;
    }

    @Override
    public void findProfilesByNames(String[] object, Agent agent, ProfileLookupCallback profileLookupCallback) {
        HashSet<ProfileCriteria> hashSet = Sets.newHashSet();
        Object stringArray = object;
        int n = ((Object)stringArray).length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            if (!Strings.isNullOrEmpty((String)object)) {
                hashSet.add(new ProfileCriteria((String)object, agent));
            }
            ++n2;
        }
        object = null;
        HashSet hashSet2 = Sets.newHashSet(hashSet);
        n = 1;
        int n3 = 0;
        if (!hashSet.isEmpty()) {
            block7: while (true) {
                try {
                    while (true) {
                        ProfileSearchResultsResponse object2 = this.authenticationService.makeRequest(HttpAuthenticationService.constantURL(SEARCH_PAGE_URL + n), hashSet2, ProfileSearchResultsResponse.class);
                        n3 = 0;
                        object = null;
                        if (object2.getSize() == 0 || object2.getProfiles().length == 0) {
                            LOGGER.a("Page %s returned empty, aborting search", n);
                            break block7;
                        }
                        LOGGER.a("Page %s returned %s results of %s, parsing", n, object2.getProfiles().length, object2.getSize());
                        GameProfile[] gameProfileArray = object2.getProfiles();
                        int n4 = gameProfileArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            GameProfile gameProfile = gameProfileArray[n5];
                            LOGGER.a("Successfully looked up profile %s", gameProfile);
                            hashSet.remove(new ProfileCriteria(gameProfile.getName(), agent));
                            profileLookupCallback.onProfileLookupSucceeded(gameProfile);
                            ++n5;
                        }
                        LOGGER.a("Page %s successfully parsed", n);
                        ++n;
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                catch (AuthenticationException authenticationException) {
                    if (++n3 == 3) break;
                    try {
                        Thread.sleep(750L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        if (hashSet.isEmpty()) {
            LOGGER.log("Successfully found every profile requested");
            return;
        }
        LOGGER.a("%s profiles were missing from search results", hashSet.size());
        if (object == null) {
            object = new ProfileNotFoundException("Server did not find the requested profile");
        }
        for (ProfileCriteria profileCriteria : hashSet) {
            profileLookupCallback.onProfileLookupFailed(new GameProfile(null, profileCriteria.getName()), (Exception)object);
        }
    }

    @d
    class ProfileCriteria {
        private final String name;
        private final String agent;

        private ProfileCriteria(String string, Agent agent) {
            this.name = string;
            this.agent = agent.getName();
        }

        public String getName() {
            return this.name;
        }

        public String getAgent() {
            return this.agent;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            object = (ProfileCriteria)object;
            return this.agent.equals(((ProfileCriteria)object).agent) && this.name.toLowerCase().equals(((ProfileCriteria)object).name.toLowerCase());
        }

        public int hashCode() {
            return 31 * this.name.toLowerCase().hashCode() + this.agent.hashCode();
        }

        public String toString() {
            return new ToStringBuilder(this).append("agent", this.agent).append("name", this.name).toString();
        }
    }
}

