/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.HttpMinecraftSessionService;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.request.JoinMinecraftServerRequest;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.authlib.yggdrasil.response.Response;
import com.mojang.util.UUIDTypeAdapter;
import com.teamextreme.fyre.a;
import com.teamextreme.fyre.b;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.commons.codec.Charsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public class YggdrasilMinecraftSessionService
extends HttpMinecraftSessionService {
    private static final a LOGGER = b.ad();
    private static final String BASE_URL = "https://sessionserver.mojang.com/session/minecraft/";
    private static final URL JOIN_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/join");
    private static final URL CHECK_URL = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/hasJoined");
    private final PublicKey publicKey;
    private final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)UUID.class), new UUIDTypeAdapter()).create();

    protected YggdrasilMinecraftSessionService(YggdrasilAuthenticationService object) {
        super((HttpAuthenticationService)object);
        try {
            object = new X509EncodedKeySpec(IOUtils.toByteArray(YggdrasilMinecraftSessionService.class.getResourceAsStream("/yggdrasil_session_pubkey.der")));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.publicKey = keyFactory.generatePublic((KeySpec)object);
            return;
        }
        catch (Exception exception) {
            throw new Error("Missing/invalid yggdrasil public key!");
        }
    }

    @Override
    public void joinServer(GameProfile gameProfile, String string, String string2) throws AuthenticationException {
        JoinMinecraftServerRequest joinMinecraftServerRequest = new JoinMinecraftServerRequest();
        new JoinMinecraftServerRequest().accessToken = string;
        joinMinecraftServerRequest.selectedProfile = gameProfile.getId();
        joinMinecraftServerRequest.serverId = string2;
        this.getAuthenticationService().makeRequest(JOIN_URL, joinMinecraftServerRequest, Response.class);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile gameProfile, String object) throws AuthenticationUnavailableException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("username", gameProfile.getName());
        hashMap.put("serverId", object);
        object = HttpAuthenticationService.concatenateURL(CHECK_URL, HttpAuthenticationService.buildQuery(hashMap));
        try {
            object = this.getAuthenticationService().makeRequest((URL)object, null, HasJoinedMinecraftServerResponse.class);
            if (object != null && ((HasJoinedMinecraftServerResponse)object).getId() != null) {
                gameProfile = new GameProfile(((HasJoinedMinecraftServerResponse)object).getId(), gameProfile.getName());
                if (((HasJoinedMinecraftServerResponse)object).getProperties() != null) {
                    gameProfile.getProperties().putAll(((HasJoinedMinecraftServerResponse)object).getProperties());
                }
                return gameProfile;
            }
            return null;
        }
        catch (AuthenticationUnavailableException authenticationUnavailableException) {
            throw authenticationUnavailableException;
        }
        catch (AuthenticationException authenticationException) {
            return null;
        }
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile object, boolean bl) {
        Object object2;
        Object object3 = Iterables.getFirst(((GameProfile)object).getProperties().get("textures"), null);
        if (object3 == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (!((Property)object3).hasSignature()) {
            LOGGER.log(Level.SEVERE, "Signature is missing from textures payload");
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (!((Property)object3).isSignatureValid(this.publicKey)) {
            LOGGER.log(Level.SEVERE, "Textures payload has been tampered with (signature invalid)");
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        try {
            object2 = new String(Base64.decodeBase64(((Property)object3).getValue()), Charsets.UTF_8);
            object3 = this.gson.fromJson((String)object2, MinecraftTexturesPayload.class);
        }
        catch (JsonParseException jsonParseException) {
            LOGGER.log(Level.SEVERE, "Could not decode textures payload", jsonParseException);
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (((MinecraftTexturesPayload)object3).getProfileId() == null || !((MinecraftTexturesPayload)object3).getProfileId().equals(((GameProfile)object).getId())) {
            LOGGER.a(Level.SEVERE, "Decrypted textures payload was for another user (expected id %s but was for %s)", ((GameProfile)object).getId(), ((MinecraftTexturesPayload)object3).getProfileId());
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (((MinecraftTexturesPayload)object3).getProfileName() == null || !((MinecraftTexturesPayload)object3).getProfileName().equals(((GameProfile)object).getName())) {
            LOGGER.a(Level.SEVERE, "Decrypted textures payload was for another user (expected name %s but was for %s)", ((GameProfile)object).getName(), ((MinecraftTexturesPayload)object3).getProfileName());
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        if (bl) {
            if (((MinecraftTexturesPayload)object3).isPublic()) {
                LOGGER.log(Level.SEVERE, "Decrypted textures payload was public but we require secure data");
                return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            }
            object2 = Calendar.getInstance();
            ((Calendar)object2).add(5, -1);
            object = new Date(((MinecraftTexturesPayload)object3).getTimestamp());
            if (((Date)object).before(((Calendar)object2).getTime())) {
                LOGGER.a(Level.SEVERE, "Decrypted textures payload is too old (%s, but we need it to be at least %s)", object, object2);
                return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
            }
        }
        if (((MinecraftTexturesPayload)object3).getTextures() == null) {
            return new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        }
        return ((MinecraftTexturesPayload)object3).getTextures();
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile gameProfile) {
        if (gameProfile.getId() == null) {
            return gameProfile;
        }
        try {
            Object object = HttpAuthenticationService.constantURL("https://sessionserver.mojang.com/session/minecraft/profile/" + gameProfile.getId());
            object = this.getAuthenticationService().makeRequest((URL)object, null, MinecraftProfilePropertiesResponse.class);
            LOGGER.log("Successfully fetched profile properties for " + gameProfile);
            GameProfile gameProfile2 = new GameProfile(((MinecraftProfilePropertiesResponse)object).getId(), ((MinecraftProfilePropertiesResponse)object).getName());
            gameProfile2.getProperties().putAll(((MinecraftProfilePropertiesResponse)object).getProperties());
            gameProfile.getProperties().putAll(((MinecraftProfilePropertiesResponse)object).getProperties());
            return gameProfile2;
        }
        catch (AuthenticationException authenticationException) {
            LOGGER.log(Level.WARNING, "Couldn't look up profile properties for " + gameProfile, authenticationException);
            return gameProfile;
        }
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }
}

